/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.services;

import java.io.IOException;
import org.ovirt.engine.sdk4.Request;
import org.ovirt.engine.sdk4.Response;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.NicBuilder;
import org.ovirt.engine.sdk4.types.Nic;

public interface VmNicService extends Service {
    public interface ActivateRequest extends Request<ActivateRequest, ActivateResponse> {
        /**
         * Indicates if the activation should be performed asynchronously.
         */
        ActivateRequest async(Boolean async);
    }
    
    public interface ActivateResponse extends Response {
    }
    
    ActivateRequest activate();
    
    public interface DeactivateRequest extends Request<DeactivateRequest, DeactivateResponse> {
        /**
         * Indicates if the deactivation should be performed asynchronously.
         */
        DeactivateRequest async(Boolean async);
    }
    
    public interface DeactivateResponse extends Response {
    }
    
    DeactivateRequest deactivate();
    
    public interface GetRequest extends Request<GetRequest, GetResponse> {
    }
    
    public interface GetResponse extends Response {
        Nic nic();
    }
    
    GetRequest get();
    
    /**
     * Removes the NIC.
     * 
     * For example, to remove the NIC with id `456` from the virtual machine with id `123` send a request like this:
     * 
     * [source]
     * ----
     * DELETE /ovirt-engine/api/vms/123/nics/456
     * ----
     * 
     * [IMPORTANT]
     * ====
     * The hotplugging feature only supports virtual machine operating systems with hotplugging operations.
     * Example operating systems include:
     * 
     * - Red Hat Enterprise Linux 6
     * - Red Hat Enterprise Linux 5
     * - Windows Server 2008 and
     * - Windows Server 2003
     * ====
     */
    public interface RemoveRequest extends Request<RemoveRequest, RemoveResponse> {
        /**
         * Indicates if the remove should be performed asynchronously.
         */
        RemoveRequest async(Boolean async);
    }
    
    /**
     * Removes the NIC.
     * 
     * For example, to remove the NIC with id `456` from the virtual machine with id `123` send a request like this:
     * 
     * [source]
     * ----
     * DELETE /ovirt-engine/api/vms/123/nics/456
     * ----
     * 
     * [IMPORTANT]
     * ====
     * The hotplugging feature only supports virtual machine operating systems with hotplugging operations.
     * Example operating systems include:
     * 
     * - Red Hat Enterprise Linux 6
     * - Red Hat Enterprise Linux 5
     * - Windows Server 2008 and
     * - Windows Server 2003
     * ====
     */
    public interface RemoveResponse extends Response {
    }
    
    /**
     * Removes the NIC.
     * 
     * For example, to remove the NIC with id `456` from the virtual machine with id `123` send a request like this:
     * 
     * [source]
     * ----
     * DELETE /ovirt-engine/api/vms/123/nics/456
     * ----
     * 
     * [IMPORTANT]
     * ====
     * The hotplugging feature only supports virtual machine operating systems with hotplugging operations.
     * Example operating systems include:
     * 
     * - Red Hat Enterprise Linux 6
     * - Red Hat Enterprise Linux 5
     * - Windows Server 2008 and
     * - Windows Server 2003
     * ====
     */
    RemoveRequest remove();
    
    /**
     * Updates the NIC.
     * 
     * For example, to update the NIC having with `456` belonging to virtual the machine with id `123` send a request
     * like this:
     * 
     * [source]
     * ----
     * PUT /ovirt-engine/api/vms/123/nics/456
     * ----
     * 
     * With a request body like this:
     * 
     * [source,xml]
     * ----
     * <nic>
     *   <name>mynic</name>
     *   <interface>e1000</interface>
     * </nic>
     * ----
     * 
     * [IMPORTANT]
     * ====
     * The hotplugging feature only supports virtual machine operating systems with hotplugging operations.
     * Example operating systems include:
     * 
     * - Red Hat Enterprise Linux 6
     * - Red Hat Enterprise Linux 5
     * - Windows Server 2008 and
     * - Windows Server 2003
     * ====
     */
    public interface UpdateRequest extends Request<UpdateRequest, UpdateResponse> {
        /**
         * Indicates if the update should be performed asynchronously.
         */
        UpdateRequest async(Boolean async);
        UpdateRequest nic(Nic nic);
        UpdateRequest nic(NicBuilder nic);
    }
    
    /**
     * Updates the NIC.
     * 
     * For example, to update the NIC having with `456` belonging to virtual the machine with id `123` send a request
     * like this:
     * 
     * [source]
     * ----
     * PUT /ovirt-engine/api/vms/123/nics/456
     * ----
     * 
     * With a request body like this:
     * 
     * [source,xml]
     * ----
     * <nic>
     *   <name>mynic</name>
     *   <interface>e1000</interface>
     * </nic>
     * ----
     * 
     * [IMPORTANT]
     * ====
     * The hotplugging feature only supports virtual machine operating systems with hotplugging operations.
     * Example operating systems include:
     * 
     * - Red Hat Enterprise Linux 6
     * - Red Hat Enterprise Linux 5
     * - Windows Server 2008 and
     * - Windows Server 2003
     * ====
     */
    public interface UpdateResponse extends Response {
        Nic nic();
    }
    
    /**
     * Updates the NIC.
     * 
     * For example, to update the NIC having with `456` belonging to virtual the machine with id `123` send a request
     * like this:
     * 
     * [source]
     * ----
     * PUT /ovirt-engine/api/vms/123/nics/456
     * ----
     * 
     * With a request body like this:
     * 
     * [source,xml]
     * ----
     * <nic>
     *   <name>mynic</name>
     *   <interface>e1000</interface>
     * </nic>
     * ----
     * 
     * [IMPORTANT]
     * ====
     * The hotplugging feature only supports virtual machine operating systems with hotplugging operations.
     * Example operating systems include:
     * 
     * - Red Hat Enterprise Linux 6
     * - Red Hat Enterprise Linux 5
     * - Windows Server 2008 and
     * - Windows Server 2003
     * ====
     */
    UpdateRequest update();
    
    VmReportedDevicesService reportedDevicesService();
    /**
     * Service locator method, returns individual service on which the URI is dispatched.
     */
    Service service(String path);
}

