/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.DomainBuilder;
import org.ovirt.engine.sdk4.builders.PermissionBuilder;
import org.ovirt.engine.sdk4.builders.RoleBuilder;
import org.ovirt.engine.sdk4.builders.TagBuilder;
import org.ovirt.engine.sdk4.internal.containers.GroupContainer;
import org.ovirt.engine.sdk4.types.Domain;
import org.ovirt.engine.sdk4.types.Group;
import org.ovirt.engine.sdk4.types.Permission;
import org.ovirt.engine.sdk4.types.Role;
import org.ovirt.engine.sdk4.types.Tag;

public class GroupBuilder {
    private String comment;
    private String description;
    private Domain domain;
    private String domainEntryId;
    private String href;
    private String id;
    private String name;
    private String namespace;
    private List<Permission> permissions;
    private List<Role> roles;
    private List<Tag> tags;

    public GroupBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public GroupBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public GroupBuilder domain(Domain newDomain) {
        this.domain = newDomain;
        return this;
    }

    public GroupBuilder domain(DomainBuilder newDomain) {
        this.domain = newDomain == null ? null : newDomain.build();
        return this;
    }

    public GroupBuilder domainEntryId(String newDomainEntryId) {
        this.domainEntryId = newDomainEntryId;
        return this;
    }

    public GroupBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public GroupBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public GroupBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public GroupBuilder namespace(String newNamespace) {
        this.namespace = newNamespace;
        return this;
    }

    public GroupBuilder permissions(List<Permission> newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions);
            } else {
                this.permissions.addAll(newPermissions);
            }
        }
        return this;
    }

    public GroupBuilder permissions(Permission ... newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions.length);
            }
            Collections.addAll(this.permissions, newPermissions);
        }
        return this;
    }

    public GroupBuilder permissions(PermissionBuilder ... newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions.length);
            }
            for (PermissionBuilder builder : newPermissions) {
                this.permissions.add(builder.build());
            }
        }
        return this;
    }

    public GroupBuilder roles(List<Role> newRoles) {
        if (newRoles != null) {
            if (this.roles == null) {
                this.roles = new ArrayList<Role>(newRoles);
            } else {
                this.roles.addAll(newRoles);
            }
        }
        return this;
    }

    public GroupBuilder roles(Role ... newRoles) {
        if (newRoles != null) {
            if (this.roles == null) {
                this.roles = new ArrayList<Role>(newRoles.length);
            }
            Collections.addAll(this.roles, newRoles);
        }
        return this;
    }

    public GroupBuilder roles(RoleBuilder ... newRoles) {
        if (newRoles != null) {
            if (this.roles == null) {
                this.roles = new ArrayList<Role>(newRoles.length);
            }
            for (RoleBuilder builder : newRoles) {
                this.roles.add(builder.build());
            }
        }
        return this;
    }

    public GroupBuilder tags(List<Tag> newTags) {
        if (newTags != null) {
            if (this.tags == null) {
                this.tags = new ArrayList<Tag>(newTags);
            } else {
                this.tags.addAll(newTags);
            }
        }
        return this;
    }

    public GroupBuilder tags(Tag ... newTags) {
        if (newTags != null) {
            if (this.tags == null) {
                this.tags = new ArrayList<Tag>(newTags.length);
            }
            Collections.addAll(this.tags, newTags);
        }
        return this;
    }

    public GroupBuilder tags(TagBuilder ... newTags) {
        if (newTags != null) {
            if (this.tags == null) {
                this.tags = new ArrayList<Tag>(newTags.length);
            }
            for (TagBuilder builder : newTags) {
                this.tags.add(builder.build());
            }
        }
        return this;
    }

    public Group build() {
        GroupContainer container = new GroupContainer();
        container.comment(this.comment);
        container.description(this.description);
        container.domain(this.domain);
        container.domainEntryId(this.domainEntryId);
        container.href(this.href);
        container.id(this.id);
        container.name(this.name);
        container.namespace(this.namespace);
        container.permissions(this.permissions);
        container.roles(this.roles);
        container.tags(this.tags);
        return container;
    }
}

