/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import org.ovirt.engine.sdk4.types.InheritableBoolean;
import org.ovirt.engine.sdk4.types.MigrationBandwidth;
import org.ovirt.engine.sdk4.types.MigrationOptions;
import org.ovirt.engine.sdk4.types.MigrationPolicy;

public class MigrationOptionsContainer extends Container implements MigrationOptions {
    private InheritableBoolean autoConverge;
    private MigrationBandwidth bandwidth;
    private InheritableBoolean compressed;
    private MigrationPolicy policy;
    
    public InheritableBoolean autoConverge() {
        return autoConverge;
    }
    
    public void autoConverge(InheritableBoolean newAutoConverge) {
        autoConverge = newAutoConverge;
    }
    
    public boolean autoConvergePresent() {
        return autoConverge != null;
    }
    
    public MigrationBandwidth bandwidth() {
        return bandwidth;
    }
    
    public void bandwidth(MigrationBandwidth newBandwidth) {
        bandwidth = newBandwidth;
    }
    
    public boolean bandwidthPresent() {
        return bandwidth != null;
    }
    
    public InheritableBoolean compressed() {
        return compressed;
    }
    
    public void compressed(InheritableBoolean newCompressed) {
        compressed = newCompressed;
    }
    
    public boolean compressedPresent() {
        return compressed != null;
    }
    
    public MigrationPolicy policy() {
        return policy;
    }
    
    public void policy(MigrationPolicy newPolicy) {
        policy = newPolicy;
    }
    
    public boolean policyPresent() {
        return policy != null;
    }
    
}
