/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.ClusterBuilder;
import org.ovirt.engine.sdk4.builders.PermissionBuilder;
import org.ovirt.engine.sdk4.builders.QosBuilder;
import org.ovirt.engine.sdk4.internal.containers.CpuProfileContainer;
import org.ovirt.engine.sdk4.types.Cluster;
import org.ovirt.engine.sdk4.types.CpuProfile;
import org.ovirt.engine.sdk4.types.Permission;
import org.ovirt.engine.sdk4.types.Qos;

public class CpuProfileBuilder {
    private Cluster cluster;
    private String comment;
    private String description;
    private String href;
    private String id;
    private String name;
    private List<Permission> permissions;
    private Qos qos;

    public CpuProfileBuilder cluster(Cluster newCluster) {
        this.cluster = newCluster;
        return this;
    }

    public CpuProfileBuilder cluster(ClusterBuilder newCluster) {
        this.cluster = newCluster == null ? null : newCluster.build();
        return this;
    }

    public CpuProfileBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public CpuProfileBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public CpuProfileBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public CpuProfileBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public CpuProfileBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public CpuProfileBuilder permissions(List<Permission> newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions);
            } else {
                this.permissions.addAll(newPermissions);
            }
        }
        return this;
    }

    public CpuProfileBuilder permissions(Permission ... newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions.length);
            }
            Collections.addAll(this.permissions, newPermissions);
        }
        return this;
    }

    public CpuProfileBuilder permissions(PermissionBuilder ... newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions.length);
            }
            for (PermissionBuilder builder : newPermissions) {
                this.permissions.add(builder.build());
            }
        }
        return this;
    }

    public CpuProfileBuilder qos(Qos newQos) {
        this.qos = newQos;
        return this;
    }

    public CpuProfileBuilder qos(QosBuilder newQos) {
        this.qos = newQos == null ? null : newQos.build();
        return this;
    }

    public CpuProfile build() {
        CpuProfileContainer container = new CpuProfileContainer();
        container.cluster(this.cluster);
        container.comment(this.comment);
        container.description(this.description);
        container.href(this.href);
        container.id(this.id);
        container.name(this.name);
        container.permissions(this.permissions);
        container.qos(this.qos);
        return container;
    }
}

