/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.String;
import org.ovirt.engine.sdk4.types.Ip;
import org.ovirt.engine.sdk4.types.IpVersion;

public class IpContainer extends Container implements Ip {
    private String address;
    private String gateway;
    private String netmask;
    private IpVersion version;
    
    public String address() {
        return address;
    }
    
    public void address(String newAddress) {
        address = newAddress;
    }
    
    public boolean addressPresent() {
        return address != null;
    }
    
    public String gateway() {
        return gateway;
    }
    
    public void gateway(String newGateway) {
        gateway = newGateway;
    }
    
    public boolean gatewayPresent() {
        return gateway != null;
    }
    
    public String netmask() {
        return netmask;
    }
    
    public void netmask(String newNetmask) {
        netmask = newNetmask;
    }
    
    public boolean netmaskPresent() {
        return netmask != null;
    }
    
    public IpVersion version() {
        return version;
    }
    
    public void version(IpVersion newVersion) {
        version = newVersion;
    }
    
    public boolean versionPresent() {
        return version != null;
    }
    
}
