/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.ProductContainer;
import org.ovirt.engine.sdk4.types.Product;

public class XmlProductReader {
    public static Product readOne(XmlReader reader) {
        if (!reader.forward()) {
            return null;
        }
        ProductContainer object = new ProductContainer();
        block20: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block20;
                }
                case "id": {
                    object.id(image);
                    continue block20;
                }
            }
        }
        reader.next();
        block21: while (reader.forward()) {
            String name;
            switch (name = reader.getLocalName()) {
                case "comment": {
                    object.comment(reader.readString());
                    continue block21;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block21;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block21;
                }
                case "link": {
                    XmlProductReader.readLink(reader, object);
                    continue block21;
                }
            }
            reader.skip();
        }
        reader.next();
        return object;
    }

    public static Iterator<Product> iterateMany(final XmlReader reader) {
        return new Iterator<Product>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public Product next() {
                Product next = XmlProductReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<Product> readMany(XmlReader reader) {
        ArrayList<Product> list = new ArrayList<Product>();
        Iterator<Product> iterator = XmlProductReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void readLink(XmlReader reader, ProductContainer object) {
        String rel = null;
        String href = null;
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attrName = reader.getAttributeLocalName(i);
            String attrVal = reader.getAttributeValue(i);
            switch (attrName) {
                case "href": {
                    href = attrVal;
                    continue block8;
                }
                case "rel": {
                    rel = attrVal;
                    continue block8;
                }
                default: {
                    reader.skip();
                }
            }
        }
        reader.skip();
    }
}

