/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.xml;

import java.util.Iterator;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.types.SchedulingPolicyUnit;

public class XmlSchedulingPolicyUnitWriter {
    
    public static void writeOne(SchedulingPolicyUnit object, XmlWriter writer) {
        writeOne(object, "scheduling_policy_unit", writer);
    }
    
    public static void writeOne(SchedulingPolicyUnit object, String tag, XmlWriter writer) {
        writer.writeStartElement(tag);
        if (object.hrefPresent()) {
            writer.writeAttribute("href", object.href());
        }
        if (object.idPresent()) {
            writer.writeAttribute("id", object.id());
        }
        if (object.commentPresent()) {
            writer.writeElement("comment", object.comment());
        }
        if (object.descriptionPresent()) {
            writer.writeElement("description", object.description());
        }
        if (object.enabledPresent()) {
            writer.writeBoolean("enabled", object.enabled());
        }
        if (object.internalPresent()) {
            writer.writeBoolean("internal", object.internal());
        }
        if (object.namePresent()) {
            writer.writeElement("name", object.name());
        }
        if (object.propertiesPresent()) {
            XmlPropertyWriter.writeMany(object.properties().iterator(), "property", "properties", writer);
        }
        if (object.typePresent()) {
            XmlPolicyUnitTypeWriter.writeOne(object.type(), "type", writer);
        }
        writer.writeEndElement();
    }
    
    public static void writeMany(Iterator<SchedulingPolicyUnit> list, XmlWriter writer) {
        writeMany(list, "scheduling_policy_unit", "scheduling_policy_units", writer);
    }
    
    public static void writeMany(Iterator<SchedulingPolicyUnit> list, String singular, String plural, XmlWriter writer) {
        writer.writeStartElement(plural);
        while (list.hasNext()) {
            XmlSchedulingPolicyUnitWriter.writeOne(list.next(), singular, writer);
        }
        writer.writeEndElement();
    }
    
}

