/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.HostedEngineContainer;
import org.ovirt.engine.sdk4.types.HostedEngine;

public class XmlHostedEngineReader {
    public static HostedEngine readOne(XmlReader reader) {
        if (!reader.forward()) {
            return null;
        }
        HostedEngineContainer object = new HostedEngineContainer();
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block16: while (reader.forward()) {
            String name;
            switch (name = reader.getLocalName()) {
                case "active": {
                    object.active(reader.readBoolean());
                    continue block16;
                }
                case "configured": {
                    object.configured(reader.readBoolean());
                    continue block16;
                }
                case "global_maintenance": {
                    object.globalMaintenance(reader.readBoolean());
                    continue block16;
                }
                case "local_maintenance": {
                    object.localMaintenance(reader.readBoolean());
                    continue block16;
                }
                case "score": {
                    object.score(reader.readInteger());
                    continue block16;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.next();
                    continue block16;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlHostedEngineReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<HostedEngine> iterateMany(final XmlReader reader) {
        return new Iterator<HostedEngine>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public HostedEngine next() {
                HostedEngine next = XmlHostedEngineReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<HostedEngine> readMany(XmlReader reader) {
        ArrayList<HostedEngine> list = new ArrayList<HostedEngine>();
        Iterator<HostedEngine> iterator = XmlHostedEngineReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(HostedEngineContainer object, String[] link) {
    }
}

