/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.util.ArrayListWithHref;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.NumaNodeContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlCpuReader;
import org.ovirt.engine.sdk4.internal.xml.XmlHostReader;
import org.ovirt.engine.sdk4.internal.xml.XmlStatisticReader;
import org.ovirt.engine.sdk4.types.NumaNode;
import org.ovirt.engine.sdk4.types.Statistic;

public class XmlNumaNodeReader {
    public static NumaNode readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        NumaNodeContainer object = new NumaNodeContainer();
        block32: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block32;
                }
                case "id": {
                    object.id(image);
                    continue block32;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block33: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "comment": {
                    object.comment(reader.readString());
                    continue block33;
                }
                case "cpu": {
                    object.cpu(XmlCpuReader.readOne(reader));
                    continue block33;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block33;
                }
                case "host": {
                    object.host(XmlHostReader.readOne(reader));
                    continue block33;
                }
                case "index": {
                    object.index(reader.readInteger());
                    continue block33;
                }
                case "memory": {
                    object.memory(reader.readInteger());
                    continue block33;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block33;
                }
                case "node_distance": {
                    object.nodeDistance(reader.readString());
                    continue block33;
                }
                case "statistics": {
                    object.statistics(XmlStatisticReader.readMany(reader));
                    continue block33;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.next();
                    continue block33;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlNumaNodeReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<NumaNode> iterateMany(final XmlReader reader) {
        return new Iterator<NumaNode>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public NumaNode next() {
                NumaNode next = XmlNumaNodeReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<NumaNode> readMany(XmlReader reader) {
        ArrayList<NumaNode> list = new ArrayList<NumaNode>();
        Iterator<NumaNode> iterator = XmlNumaNodeReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(NumaNodeContainer object, String[] link) {
        String rel = link[0];
        String href = link[1];
        if (href != null) {
            switch (rel) {
                case "statistics": {
                    ArrayListWithHref<Statistic> list = new ArrayListWithHref<Statistic>(object.statistics());
                    list.href(href);
                    object.statistics(list);
                    break;
                }
            }
        }
    }
}

