/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.PackageContainer;
import org.ovirt.engine.sdk4.types.Package;

public class XmlPackageReader {
    public static Package readOne(XmlReader reader) {
        if (!reader.forward()) {
            return null;
        }
        PackageContainer object = new PackageContainer();
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block8: while (reader.forward()) {
            String name;
            switch (name = reader.getLocalName()) {
                case "name": {
                    object.name(reader.readString());
                    continue block8;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block8;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlPackageReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<Package> iterateMany(final XmlReader reader) {
        return new Iterator<Package>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public Package next() {
                Package next = XmlPackageReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<Package> readMany(XmlReader reader) {
        ArrayList<Package> list = new ArrayList<Package>();
        Iterator<Package> iterator = XmlPackageReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(PackageContainer object, String[] link) {
    }
}

