/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.Boolean;
import java.math.BigInteger;
import org.ovirt.engine.sdk4.types.HostedEngine;

public class HostedEngineContainer extends Container implements HostedEngine {
    private Boolean active;
    private Boolean configured;
    private Boolean globalMaintenance;
    private Boolean localMaintenance;
    private BigInteger score;
    
    public boolean active() {
        return active;
    }
    
    public void active(boolean newActive) {
        active = Boolean.valueOf(newActive);
    }
    
    public void active(Boolean newActive) {
        active = newActive;
    }
    
    public boolean activePresent() {
        return active != null;
    }
    
    public boolean configured() {
        return configured;
    }
    
    public void configured(boolean newConfigured) {
        configured = Boolean.valueOf(newConfigured);
    }
    
    public void configured(Boolean newConfigured) {
        configured = newConfigured;
    }
    
    public boolean configuredPresent() {
        return configured != null;
    }
    
    public boolean globalMaintenance() {
        return globalMaintenance;
    }
    
    public void globalMaintenance(boolean newGlobalMaintenance) {
        globalMaintenance = Boolean.valueOf(newGlobalMaintenance);
    }
    
    public void globalMaintenance(Boolean newGlobalMaintenance) {
        globalMaintenance = newGlobalMaintenance;
    }
    
    public boolean globalMaintenancePresent() {
        return globalMaintenance != null;
    }
    
    public boolean localMaintenance() {
        return localMaintenance;
    }
    
    public void localMaintenance(boolean newLocalMaintenance) {
        localMaintenance = Boolean.valueOf(newLocalMaintenance);
    }
    
    public void localMaintenance(Boolean newLocalMaintenance) {
        localMaintenance = newLocalMaintenance;
    }
    
    public boolean localMaintenancePresent() {
        return localMaintenance != null;
    }
    
    public BigInteger score() {
        return score;
    }
    
    public void score(BigInteger newScore) {
        score = newScore;
    }
    
    public boolean scorePresent() {
        return score != null;
    }
    
}
