/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.PermissionBuilder;
import org.ovirt.engine.sdk4.builders.QosBuilder;
import org.ovirt.engine.sdk4.builders.StorageDomainBuilder;
import org.ovirt.engine.sdk4.internal.containers.DiskProfileContainer;
import org.ovirt.engine.sdk4.types.DiskProfile;
import org.ovirt.engine.sdk4.types.Permission;
import org.ovirt.engine.sdk4.types.Qos;
import org.ovirt.engine.sdk4.types.StorageDomain;

public class DiskProfileBuilder {
    private String comment;
    private String description;
    private String href;
    private String id;
    private String name;
    private List<Permission> permissions;
    private Qos qos;
    private StorageDomain storageDomain;

    public DiskProfileBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public DiskProfileBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public DiskProfileBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public DiskProfileBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public DiskProfileBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public DiskProfileBuilder permissions(List<Permission> newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions);
            } else {
                this.permissions.addAll(newPermissions);
            }
        }
        return this;
    }

    public DiskProfileBuilder permissions(Permission ... newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions.length);
            }
            Collections.addAll(this.permissions, newPermissions);
        }
        return this;
    }

    public DiskProfileBuilder permissions(PermissionBuilder ... newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions.length);
            }
            for (PermissionBuilder builder : newPermissions) {
                this.permissions.add(builder.build());
            }
        }
        return this;
    }

    public DiskProfileBuilder qos(Qos newQos) {
        this.qos = newQos;
        return this;
    }

    public DiskProfileBuilder qos(QosBuilder newQos) {
        this.qos = newQos == null ? null : newQos.build();
        return this;
    }

    public DiskProfileBuilder storageDomain(StorageDomain newStorageDomain) {
        this.storageDomain = newStorageDomain;
        return this;
    }

    public DiskProfileBuilder storageDomain(StorageDomainBuilder newStorageDomain) {
        this.storageDomain = newStorageDomain == null ? null : newStorageDomain.build();
        return this;
    }

    public DiskProfile build() {
        DiskProfileContainer container = new DiskProfileContainer();
        container.comment(this.comment);
        container.description(this.description);
        container.href(this.href);
        container.id(this.id);
        container.name(this.name);
        container.permissions(this.permissions);
        container.qos(this.qos);
        container.storageDomain(this.storageDomain);
        return container;
    }
}

