/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.util.ArrayListWithHref;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.GroupContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlDomainReader;
import org.ovirt.engine.sdk4.internal.xml.XmlPermissionReader;
import org.ovirt.engine.sdk4.internal.xml.XmlRoleReader;
import org.ovirt.engine.sdk4.internal.xml.XmlTagReader;
import org.ovirt.engine.sdk4.types.Group;
import org.ovirt.engine.sdk4.types.Permission;
import org.ovirt.engine.sdk4.types.Role;
import org.ovirt.engine.sdk4.types.Tag;

public class XmlGroupReader {
    public static Group readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        GroupContainer object = new GroupContainer();
        block32: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block32;
                }
                case "id": {
                    object.id(image);
                    continue block32;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block33: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "comment": {
                    object.comment(reader.readString());
                    continue block33;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block33;
                }
                case "domain": {
                    object.domain(XmlDomainReader.readOne(reader));
                    continue block33;
                }
                case "domain_entry_id": {
                    object.domainEntryId(reader.readString());
                    continue block33;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block33;
                }
                case "namespace": {
                    object.namespace(reader.readString());
                    continue block33;
                }
                case "permissions": {
                    object.permissions(XmlPermissionReader.readMany(reader));
                    continue block33;
                }
                case "roles": {
                    object.roles(XmlRoleReader.readMany(reader));
                    continue block33;
                }
                case "tags": {
                    object.tags(XmlTagReader.readMany(reader));
                    continue block33;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block33;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlGroupReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<Group> iterateMany(final XmlReader reader) {
        return new Iterator<Group>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public Group next() {
                Group next = XmlGroupReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<Group> readMany(XmlReader reader) {
        ArrayList<Group> list = new ArrayList<Group>();
        Iterator<Group> iterator = XmlGroupReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(GroupContainer object, String[] link) {
        String rel = link[0];
        String href = link[1];
        if (href != null) {
            switch (rel) {
                case "permissions": {
                    ArrayListWithHref<Permission> list = new ArrayListWithHref<Permission>(object.permissions());
                    list.href(href);
                    object.permissions(list);
                    break;
                }
                case "roles": {
                    ArrayListWithHref<Role> list = new ArrayListWithHref<Role>(object.roles());
                    list.href(href);
                    object.roles(list);
                    break;
                }
                case "tags": {
                    ArrayListWithHref<Tag> list = new ArrayListWithHref<Tag>(object.tags());
                    list.href(href);
                    object.tags(list);
                    break;
                }
            }
        }
    }
}

