/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum HostStatus {
    DOWN,
    ERROR,
    INITIALIZING,
    INSTALLING,
    INSTALL_FAILED,
    MAINTENANCE,
    NON_OPERATIONAL,
    NON_RESPONSIVE,
    PENDING_APPROVAL,
    PREPARING_FOR_MAINTENANCE,
    CONNECTING,
    REBOOT,
    UNASSIGNED,
    UP,
    INSTALLING_OS,
    KDUMPING;

    private static final Logger LOG;

    public String value() {
        return this.name().toLowerCase();
    }

    public static HostStatus fromValue(String value) {
        try {
            return HostStatus.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOG.error("The string '" + value + "' isn't a valid value for the 'HostStatus' enumerated type. Valid values are: 'down', 'error', 'initializing', 'installing', 'install_failed', 'maintenance', 'non_operational', 'non_responsive', 'pending_approval', 'preparing_for_maintenance', 'connecting', 'reboot', 'unassigned', 'up', 'installing_os', 'kdumping'.");
            return null;
        }
    }

    static {
        LOG = LoggerFactory.getLogger(HostStatus.class);
    }
}

