/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.util.List;
import org.ovirt.engine.sdk4.types.Certificate;
import org.ovirt.engine.sdk4.types.DataCenter;
import org.ovirt.engine.sdk4.types.OpenStackVolumeProvider;
import org.ovirt.engine.sdk4.types.OpenStackVolumeType;
import org.ovirt.engine.sdk4.types.OpenstackVolumeAuthenticationKey;

public class OpenStackVolumeProviderContainer extends OpenStackProviderContainer implements OpenStackVolumeProvider {
    private List<OpenstackVolumeAuthenticationKey> authenticationKeys;
    private List<Certificate> certificates;
    private DataCenter dataCenter;
    private List<OpenStackVolumeType> volumeTypes;
    
    public List<OpenstackVolumeAuthenticationKey> authenticationKeys() {
        return makeUnmodifiableList(authenticationKeys);
    }
    
    public void authenticationKeys(List<OpenstackVolumeAuthenticationKey> newAuthenticationKeys) {
        authenticationKeys = makeArrayList(newAuthenticationKeys);
    }
    
    public boolean authenticationKeysPresent() {
        return authenticationKeys != null && !authenticationKeys.isEmpty();
    }
    
    public List<Certificate> certificates() {
        return makeUnmodifiableList(certificates);
    }
    
    public void certificates(List<Certificate> newCertificates) {
        certificates = makeArrayList(newCertificates);
    }
    
    public boolean certificatesPresent() {
        return certificates != null && !certificates.isEmpty();
    }
    
    public DataCenter dataCenter() {
        return dataCenter;
    }
    
    public void dataCenter(DataCenter newDataCenter) {
        dataCenter = newDataCenter;
    }
    
    public boolean dataCenterPresent() {
        return dataCenter != null;
    }
    
    public List<OpenStackVolumeType> volumeTypes() {
        return makeUnmodifiableList(volumeTypes);
    }
    
    public void volumeTypes(List<OpenStackVolumeType> newVolumeTypes) {
        volumeTypes = makeArrayList(newVolumeTypes);
    }
    
    public boolean volumeTypesPresent() {
        return volumeTypes != null && !volumeTypes.isEmpty();
    }
    
}
