/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;

import java.util.List;

/**
 * Represents an external host provider,
 * such as Foreman or Satellite.
 * 
 * See https://www.theforeman.org/ for more details on Foreman.
 * See https://access.redhat.com/products/red-hat-satellite
 * for more details on Red Hat Satellite.
 */
public interface ExternalHostProvider extends ExternalProvider {
    List<Certificate> certificates();
    
    boolean certificatesPresent();
    
    List<ExternalComputeResource> computeResources();
    
    boolean computeResourcesPresent();
    
    List<ExternalDiscoveredHost> discoveredHosts();
    
    boolean discoveredHostsPresent();
    
    List<ExternalHostGroup> hostGroups();
    
    boolean hostGroupsPresent();
    
    List<Host> hosts();
    
    boolean hostsPresent();
    
}
