/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.xml;

import java.util.Iterator;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.types.ImageTransfer;

public class XmlImageTransferWriter {
    
    public static void writeOne(ImageTransfer object, XmlWriter writer) {
        writeOne(object, "image_transfer", writer);
    }
    
    public static void writeOne(ImageTransfer object, String tag, XmlWriter writer) {
        writer.writeStartElement(tag);
        if (object.hrefPresent()) {
            writer.writeAttribute("href", object.href());
        }
        if (object.idPresent()) {
            writer.writeAttribute("id", object.id());
        }
        if (object.commentPresent()) {
            writer.writeElement("comment", object.comment());
        }
        if (object.descriptionPresent()) {
            writer.writeElement("description", object.description());
        }
        if (object.directionPresent()) {
            XmlImageTransferDirectionWriter.writeOne(object.direction(), "direction", writer);
        }
        if (object.diskPresent()) {
            XmlDiskWriter.writeOne(object.disk(), "disk", writer);
        }
        if (object.hostPresent()) {
            XmlHostWriter.writeOne(object.host(), "host", writer);
        }
        if (object.imagePresent()) {
            XmlImageWriter.writeOne(object.image(), "image", writer);
        }
        if (object.namePresent()) {
            writer.writeElement("name", object.name());
        }
        if (object.phasePresent()) {
            XmlImageTransferPhaseWriter.writeOne(object.phase(), "phase", writer);
        }
        if (object.proxyUrlPresent()) {
            writer.writeElement("proxy_url", object.proxyUrl());
        }
        if (object.signedTicketPresent()) {
            writer.writeElement("signed_ticket", object.signedTicket());
        }
        if (object.snapshotPresent()) {
            XmlDiskSnapshotWriter.writeOne(object.snapshot(), "snapshot", writer);
        }
        writer.writeEndElement();
    }
    
    public static void writeMany(Iterator<ImageTransfer> list, XmlWriter writer) {
        writeMany(list, "image_transfer", "image_transfers", writer);
    }
    
    public static void writeMany(Iterator<ImageTransfer> list, String singular, String plural, XmlWriter writer) {
        writer.writeStartElement(plural);
        while (list.hasNext()) {
            XmlImageTransferWriter.writeOne(list.next(), singular, writer);
        }
        writer.writeEndElement();
    }
    
}

