/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.util.ArrayListWithHref;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.DiskSnapshotContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskContentTypeReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskFormatReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskInterfaceReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskProfileReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskStatusReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskStorageTypeReader;
import org.ovirt.engine.sdk4.internal.xml.XmlHostStorageReader;
import org.ovirt.engine.sdk4.internal.xml.XmlInstanceTypeReader;
import org.ovirt.engine.sdk4.internal.xml.XmlOpenStackVolumeTypeReader;
import org.ovirt.engine.sdk4.internal.xml.XmlPermissionReader;
import org.ovirt.engine.sdk4.internal.xml.XmlQcowVersionReader;
import org.ovirt.engine.sdk4.internal.xml.XmlQuotaReader;
import org.ovirt.engine.sdk4.internal.xml.XmlScsiGenericIOReader;
import org.ovirt.engine.sdk4.internal.xml.XmlSnapshotReader;
import org.ovirt.engine.sdk4.internal.xml.XmlStatisticReader;
import org.ovirt.engine.sdk4.internal.xml.XmlStorageDomainReader;
import org.ovirt.engine.sdk4.internal.xml.XmlTemplateReader;
import org.ovirt.engine.sdk4.internal.xml.XmlVmReader;
import org.ovirt.engine.sdk4.types.DiskSnapshot;
import org.ovirt.engine.sdk4.types.Permission;
import org.ovirt.engine.sdk4.types.Statistic;
import org.ovirt.engine.sdk4.types.StorageDomain;
import org.ovirt.engine.sdk4.types.Vm;

public class XmlDiskSnapshotReader {
    public static DiskSnapshot readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        DiskSnapshotContainer object = new DiskSnapshotContainer();
        block92: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block92;
                }
                case "id": {
                    object.id(image);
                    continue block92;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block93: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "active": {
                    object.active(reader.readBoolean());
                    continue block93;
                }
                case "actual_size": {
                    object.actualSize(reader.readInteger());
                    continue block93;
                }
                case "alias": {
                    object.alias(reader.readString());
                    continue block93;
                }
                case "bootable": {
                    object.bootable(reader.readBoolean());
                    continue block93;
                }
                case "comment": {
                    object.comment(reader.readString());
                    continue block93;
                }
                case "content_type": {
                    object.contentType(XmlDiskContentTypeReader.readOne(reader));
                    continue block93;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block93;
                }
                case "disk": {
                    object.disk(XmlDiskReader.readOne(reader));
                    continue block93;
                }
                case "disk_profile": {
                    object.diskProfile(XmlDiskProfileReader.readOne(reader));
                    continue block93;
                }
                case "format": {
                    object.format(XmlDiskFormatReader.readOne(reader));
                    continue block93;
                }
                case "image_id": {
                    object.imageId(reader.readString());
                    continue block93;
                }
                case "initial_size": {
                    object.initialSize(reader.readInteger());
                    continue block93;
                }
                case "instance_type": {
                    object.instanceType(XmlInstanceTypeReader.readOne(reader));
                    continue block93;
                }
                case "interface": {
                    object.interface_(XmlDiskInterfaceReader.readOne(reader));
                    continue block93;
                }
                case "logical_name": {
                    object.logicalName(reader.readString());
                    continue block93;
                }
                case "lun_storage": {
                    object.lunStorage(XmlHostStorageReader.readOne(reader));
                    continue block93;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block93;
                }
                case "openstack_volume_type": {
                    object.openstackVolumeType(XmlOpenStackVolumeTypeReader.readOne(reader));
                    continue block93;
                }
                case "permissions": {
                    object.permissions(XmlPermissionReader.readMany(reader));
                    continue block93;
                }
                case "propagate_errors": {
                    object.propagateErrors(reader.readBoolean());
                    continue block93;
                }
                case "provisioned_size": {
                    object.provisionedSize(reader.readInteger());
                    continue block93;
                }
                case "qcow_version": {
                    object.qcowVersion(XmlQcowVersionReader.readOne(reader));
                    continue block93;
                }
                case "quota": {
                    object.quota(XmlQuotaReader.readOne(reader));
                    continue block93;
                }
                case "read_only": {
                    object.readOnly(reader.readBoolean());
                    continue block93;
                }
                case "sgio": {
                    object.sgio(XmlScsiGenericIOReader.readOne(reader));
                    continue block93;
                }
                case "shareable": {
                    object.shareable(reader.readBoolean());
                    continue block93;
                }
                case "snapshot": {
                    object.snapshot(XmlSnapshotReader.readOne(reader));
                    continue block93;
                }
                case "sparse": {
                    object.sparse(reader.readBoolean());
                    continue block93;
                }
                case "statistics": {
                    object.statistics(XmlStatisticReader.readMany(reader));
                    continue block93;
                }
                case "status": {
                    object.status(XmlDiskStatusReader.readOne(reader));
                    continue block93;
                }
                case "storage_domain": {
                    object.storageDomain(XmlStorageDomainReader.readOne(reader));
                    continue block93;
                }
                case "storage_domains": {
                    object.storageDomains(XmlStorageDomainReader.readMany(reader));
                    continue block93;
                }
                case "storage_type": {
                    object.storageType(XmlDiskStorageTypeReader.readOne(reader));
                    continue block93;
                }
                case "template": {
                    object.template(XmlTemplateReader.readOne(reader));
                    continue block93;
                }
                case "total_size": {
                    object.totalSize(reader.readInteger());
                    continue block93;
                }
                case "uses_scsi_reservation": {
                    object.usesScsiReservation(reader.readBoolean());
                    continue block93;
                }
                case "vm": {
                    object.vm(XmlVmReader.readOne(reader));
                    continue block93;
                }
                case "vms": {
                    object.vms(XmlVmReader.readMany(reader));
                    continue block93;
                }
                case "wipe_after_delete": {
                    object.wipeAfterDelete(reader.readBoolean());
                    continue block93;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block93;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlDiskSnapshotReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<DiskSnapshot> iterateMany(final XmlReader reader) {
        return new Iterator<DiskSnapshot>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public DiskSnapshot next() {
                DiskSnapshot next = XmlDiskSnapshotReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<DiskSnapshot> readMany(XmlReader reader) {
        ArrayList<DiskSnapshot> list = new ArrayList<DiskSnapshot>();
        Iterator<DiskSnapshot> iterator = XmlDiskSnapshotReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(DiskSnapshotContainer object, String[] link) {
        String rel = link[0];
        String href = link[1];
        if (href != null) {
            switch (rel) {
                case "permissions": {
                    ArrayListWithHref<Permission> list = new ArrayListWithHref<Permission>(object.permissions());
                    list.href(href);
                    object.permissions(list);
                    break;
                }
                case "statistics": {
                    ArrayListWithHref<Statistic> list = new ArrayListWithHref<Statistic>(object.statistics());
                    list.href(href);
                    object.statistics(list);
                    break;
                }
                case "storagedomains": {
                    ArrayListWithHref<StorageDomain> list = new ArrayListWithHref<StorageDomain>(object.storageDomains());
                    list.href(href);
                    object.storageDomains(list);
                    break;
                }
                case "vms": {
                    ArrayListWithHref<Vm> list = new ArrayListWithHref<Vm>(object.vms());
                    list.href(href);
                    object.vms(list);
                    break;
                }
            }
        }
    }
}

