/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import org.ovirt.engine.sdk4.builders.StorageDomainBuilder;
import org.ovirt.engine.sdk4.internal.containers.ImageContainer;
import org.ovirt.engine.sdk4.types.Image;
import org.ovirt.engine.sdk4.types.ImageFileType;
import org.ovirt.engine.sdk4.types.StorageDomain;

public class ImageBuilder {
    private String comment;
    private String description;
    private String href;
    private String id;
    private String name;
    private BigInteger size;
    private StorageDomain storageDomain;
    private ImageFileType type;

    public ImageBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public ImageBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public ImageBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public ImageBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public ImageBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public ImageBuilder size(int newSize) {
        this.size = BigInteger.valueOf(newSize);
        return this;
    }

    public ImageBuilder size(Integer newSize) {
        this.size = newSize == null ? null : BigInteger.valueOf(newSize.longValue());
        return this;
    }

    public ImageBuilder size(long newSize) {
        this.size = BigInteger.valueOf(newSize);
        return this;
    }

    public ImageBuilder size(Long newSize) {
        this.size = newSize == null ? null : BigInteger.valueOf(newSize);
        return this;
    }

    public ImageBuilder size(BigInteger newSize) {
        this.size = newSize;
        return this;
    }

    public ImageBuilder storageDomain(StorageDomain newStorageDomain) {
        this.storageDomain = newStorageDomain;
        return this;
    }

    public ImageBuilder storageDomain(StorageDomainBuilder newStorageDomain) {
        this.storageDomain = newStorageDomain == null ? null : newStorageDomain.build();
        return this;
    }

    public ImageBuilder type(ImageFileType newType) {
        this.type = newType;
        return this;
    }

    public Image build() {
        ImageContainer container = new ImageContainer();
        container.comment(this.comment);
        container.description(this.description);
        container.href(this.href);
        container.id(this.id);
        container.name(this.name);
        container.size(this.size);
        container.storageDomain(this.storageDomain);
        container.type(this.type);
        return container;
    }
}

