/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.NetworkAttachmentContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlDnsResolverConfigurationReader;
import org.ovirt.engine.sdk4.internal.xml.XmlHostNicReader;
import org.ovirt.engine.sdk4.internal.xml.XmlHostReader;
import org.ovirt.engine.sdk4.internal.xml.XmlIpAddressAssignmentReader;
import org.ovirt.engine.sdk4.internal.xml.XmlNetworkReader;
import org.ovirt.engine.sdk4.internal.xml.XmlPropertyReader;
import org.ovirt.engine.sdk4.internal.xml.XmlQosReader;
import org.ovirt.engine.sdk4.internal.xml.XmlReportedConfigurationReader;
import org.ovirt.engine.sdk4.types.NetworkAttachment;

public class XmlNetworkAttachmentReader {
    public static NetworkAttachment readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        NetworkAttachmentContainer object = new NetworkAttachmentContainer();
        block38: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block38;
                }
                case "id": {
                    object.id(image);
                    continue block38;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block39: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "comment": {
                    object.comment(reader.readString());
                    continue block39;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block39;
                }
                case "dns_resolver_configuration": {
                    object.dnsResolverConfiguration(XmlDnsResolverConfigurationReader.readOne(reader));
                    continue block39;
                }
                case "host": {
                    object.host(XmlHostReader.readOne(reader));
                    continue block39;
                }
                case "host_nic": {
                    object.hostNic(XmlHostNicReader.readOne(reader));
                    continue block39;
                }
                case "in_sync": {
                    object.inSync(reader.readBoolean());
                    continue block39;
                }
                case "ip_address_assignments": {
                    object.ipAddressAssignments(XmlIpAddressAssignmentReader.readMany(reader));
                    continue block39;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block39;
                }
                case "network": {
                    object.network(XmlNetworkReader.readOne(reader));
                    continue block39;
                }
                case "properties": {
                    object.properties(XmlPropertyReader.readMany(reader));
                    continue block39;
                }
                case "qos": {
                    object.qos(XmlQosReader.readOne(reader));
                    continue block39;
                }
                case "reported_configurations": {
                    object.reportedConfigurations(XmlReportedConfigurationReader.readMany(reader));
                    continue block39;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block39;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlNetworkAttachmentReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<NetworkAttachment> iterateMany(final XmlReader reader) {
        return new Iterator<NetworkAttachment>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public NetworkAttachment next() {
                NetworkAttachment next = XmlNetworkAttachmentReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<NetworkAttachment> readMany(XmlReader reader) {
        ArrayList<NetworkAttachment> list = new ArrayList<NetworkAttachment>();
        Iterator<NetworkAttachment> iterator = XmlNetworkAttachmentReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(NetworkAttachmentContainer object, String[] link) {
    }
}

