/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum HostProtocol {
    STOMP("stomp"),
    XML("xml");

    private static final Logger log;
    private String image;

    private HostProtocol(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static HostProtocol fromValue(String value) {
        try {
            return HostProtocol.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'HostProtocol' enumerated type. Valid values are 'stomp' and 'xml'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(HostProtocol.class);
    }
}

