/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * The actual content residing on the disk.
 */
public enum DiskContentType {
    /**
     * The disk contains data.
     */
    DATA("data"),
    /**
     * The disk contains an ISO image to be used a CDROM device.
     */
    ISO("iso"),
    /**
     * The disk contains a memory dump from a live snapshot.
     */
    MEMORY_DUMP_VOLUME("memory_dump_volume"),
    /**
     * The disk contains memory metadata from a live snapshot.
     */
    MEMORY_METADATA_VOLUME("memory_metadata_volume"),
    /**
     * The disk is an OVF store.
     */
    OVF_STORE("ovf_store"),
    ;
    
    private static final Logger log = LoggerFactory.getLogger(DiskContentType.class);
    
    private String image;
    
    DiskContentType(String image) {
        this.image = image;
    }
    
    public String value() {
        return image;
    }
    
    public static DiskContentType fromValue(String value) {
        try {
            return valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error(
            "The string '" + value + "' isn't a valid value for the 'DiskContentType' enumerated type. " +
            "Valid values are 'data', 'iso', 'memory_dump_volume', 'memory_metadata_volume' and 'ovf_store'.",
            exception
            );
            return null;
        }
    }
    
}

