/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum GlusterVolumeType {
    DISPERSE("disperse"),
    DISTRIBUTE("distribute"),
    DISTRIBUTED_DISPERSE("distributed_disperse"),
    DISTRIBUTED_REPLICATE("distributed_replicate"),
    DISTRIBUTED_STRIPE("distributed_stripe"),
    DISTRIBUTED_STRIPED_REPLICATE("distributed_striped_replicate"),
    REPLICATE("replicate"),
    STRIPE("stripe"),
    STRIPED_REPLICATE("striped_replicate");

    private static final Logger log;
    private String image;

    private GlusterVolumeType(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static GlusterVolumeType fromValue(String value) {
        try {
            return GlusterVolumeType.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'GlusterVolumeType' enumerated type. Valid values are 'disperse', 'distribute', 'distributed_disperse', 'distributed_replicate', 'distributed_stripe', 'distributed_striped_replicate', 'replicate', 'stripe' and 'striped_replicate'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(GlusterVolumeType.class);
    }
}

