/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.DisplayContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlCertificateReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDisplayTypeReader;
import org.ovirt.engine.sdk4.types.Display;

public class XmlDisplayReader {
    public static Display readOne(XmlReader reader) {
        if (!reader.forward()) {
            return null;
        }
        DisplayContainer object = new DisplayContainer();
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block34: while (reader.forward()) {
            String name;
            switch (name = reader.getLocalName()) {
                case "address": {
                    object.address(reader.readString());
                    continue block34;
                }
                case "allow_override": {
                    object.allowOverride(reader.readBoolean());
                    continue block34;
                }
                case "certificate": {
                    object.certificate(XmlCertificateReader.readOne(reader));
                    continue block34;
                }
                case "copy_paste_enabled": {
                    object.copyPasteEnabled(reader.readBoolean());
                    continue block34;
                }
                case "disconnect_action": {
                    object.disconnectAction(reader.readString());
                    continue block34;
                }
                case "file_transfer_enabled": {
                    object.fileTransferEnabled(reader.readBoolean());
                    continue block34;
                }
                case "keyboard_layout": {
                    object.keyboardLayout(reader.readString());
                    continue block34;
                }
                case "monitors": {
                    object.monitors(reader.readInteger());
                    continue block34;
                }
                case "port": {
                    object.port(reader.readInteger());
                    continue block34;
                }
                case "proxy": {
                    object.proxy(reader.readString());
                    continue block34;
                }
                case "secure_port": {
                    object.securePort(reader.readInteger());
                    continue block34;
                }
                case "single_qxl_pci": {
                    object.singleQxlPci(reader.readBoolean());
                    continue block34;
                }
                case "smartcard_enabled": {
                    object.smartcardEnabled(reader.readBoolean());
                    continue block34;
                }
                case "type": {
                    object.type(XmlDisplayTypeReader.readOne(reader));
                    continue block34;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block34;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlDisplayReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<Display> iterateMany(final XmlReader reader) {
        return new Iterator<Display>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public Display next() {
                Display next = XmlDisplayReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<Display> readMany(XmlReader reader) {
        ArrayList<Display> list = new ArrayList<Display>();
        Iterator<Display> iterator = XmlDisplayReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(DisplayContainer object, String[] link) {
    }
}

