/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import org.ovirt.engine.sdk4.builders.TemplateBuilder;
import org.ovirt.engine.sdk4.internal.containers.TemplateVersionContainer;
import org.ovirt.engine.sdk4.types.Template;
import org.ovirt.engine.sdk4.types.TemplateVersion;

public class TemplateVersionBuilder {
    private Template baseTemplate;
    private String versionName;
    private BigInteger versionNumber;

    public TemplateVersionBuilder baseTemplate(Template newBaseTemplate) {
        this.baseTemplate = newBaseTemplate;
        return this;
    }

    public TemplateVersionBuilder baseTemplate(TemplateBuilder newBaseTemplate) {
        this.baseTemplate = newBaseTemplate == null ? null : newBaseTemplate.build();
        return this;
    }

    public TemplateVersionBuilder versionName(String newVersionName) {
        this.versionName = newVersionName;
        return this;
    }

    public TemplateVersionBuilder versionNumber(int newVersionNumber) {
        this.versionNumber = BigInteger.valueOf(newVersionNumber);
        return this;
    }

    public TemplateVersionBuilder versionNumber(Integer newVersionNumber) {
        this.versionNumber = newVersionNumber == null ? null : BigInteger.valueOf(newVersionNumber.longValue());
        return this;
    }

    public TemplateVersionBuilder versionNumber(long newVersionNumber) {
        this.versionNumber = BigInteger.valueOf(newVersionNumber);
        return this;
    }

    public TemplateVersionBuilder versionNumber(Long newVersionNumber) {
        this.versionNumber = newVersionNumber == null ? null : BigInteger.valueOf(newVersionNumber);
        return this;
    }

    public TemplateVersionBuilder versionNumber(BigInteger newVersionNumber) {
        this.versionNumber = newVersionNumber;
        return this;
    }

    public TemplateVersion build() {
        TemplateVersionContainer container = new TemplateVersionContainer();
        container.baseTemplate(this.baseTemplate);
        container.versionName(this.versionName);
        container.versionNumber(this.versionNumber);
        return container;
    }
}

