/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * This type represents the kind of resource the <<types/qos,Quality of service (QoS)>> can be assigned to.
 */
public enum QosType {
    /**
     * The <<types/qos,Quality of service (QoS)>> can be assigned to resources with computing capabilities.
     */
    CPU("cpu"),
    /**
     * The <<types/qos,Quality of service (QoS)>> can be assigned to host networks.
     */
    HOSTNETWORK("hostnetwork"),
    /**
     * The <<types/qos,Quality of service (QoS)>> can be assigned to virtual machines networks.
     */
    NETWORK("network"),
    /**
     * The <<types/qos,Quality of service (QoS)>> can be assigned to storage.
     */
    STORAGE("storage"),
    ;
    
    private static final Logger log = LoggerFactory.getLogger(QosType.class);
    
    private String image;
    
    QosType(String image) {
        this.image = image;
    }
    
    public String value() {
        return image;
    }
    
    public static QosType fromValue(String value) {
        try {
            return valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error(
            "The string '" + value + "' isn't a valid value for the 'QosType' enumerated type. " +
            "Valid values are 'cpu', 'hostnetwork', 'network' and 'storage'.",
            exception
            );
            return null;
        }
    }
    
}

