/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import org.ovirt.engine.sdk4.builders.NumaNodeBuilder;
import org.ovirt.engine.sdk4.internal.containers.NumaNodePinContainer;
import org.ovirt.engine.sdk4.types.NumaNode;
import org.ovirt.engine.sdk4.types.NumaNodePin;

public class NumaNodePinBuilder {
    private NumaNode hostNumaNode;
    private BigInteger index;
    private Boolean pinned;

    public NumaNodePinBuilder hostNumaNode(NumaNode newHostNumaNode) {
        this.hostNumaNode = newHostNumaNode;
        return this;
    }

    public NumaNodePinBuilder hostNumaNode(NumaNodeBuilder newHostNumaNode) {
        this.hostNumaNode = newHostNumaNode == null ? null : newHostNumaNode.build();
        return this;
    }

    public NumaNodePinBuilder index(int newIndex) {
        this.index = BigInteger.valueOf(newIndex);
        return this;
    }

    public NumaNodePinBuilder index(Integer newIndex) {
        this.index = newIndex == null ? null : BigInteger.valueOf(newIndex.longValue());
        return this;
    }

    public NumaNodePinBuilder index(long newIndex) {
        this.index = BigInteger.valueOf(newIndex);
        return this;
    }

    public NumaNodePinBuilder index(Long newIndex) {
        this.index = newIndex == null ? null : BigInteger.valueOf(newIndex);
        return this;
    }

    public NumaNodePinBuilder index(BigInteger newIndex) {
        this.index = newIndex;
        return this;
    }

    public NumaNodePinBuilder pinned(boolean newPinned) {
        this.pinned = newPinned;
        return this;
    }

    public NumaNodePinBuilder pinned(Boolean newPinned) {
        this.pinned = newPinned;
        return this;
    }

    public NumaNodePin build() {
        NumaNodePinContainer container = new NumaNodePinContainer();
        container.hostNumaNode(this.hostNumaNode);
        container.index(this.index);
        container.pinned(this.pinned);
        return container;
    }
}

