/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.HardwareInformationContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlRngSourceReader;
import org.ovirt.engine.sdk4.types.HardwareInformation;

public class XmlHardwareInformationReader {
    public static HardwareInformation readOne(XmlReader reader) {
        if (!reader.forward()) {
            return null;
        }
        HardwareInformationContainer object = new HardwareInformationContainer();
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block20: while (reader.forward()) {
            String name;
            switch (name = reader.getLocalName()) {
                case "family": {
                    object.family(reader.readString());
                    continue block20;
                }
                case "manufacturer": {
                    object.manufacturer(reader.readString());
                    continue block20;
                }
                case "product_name": {
                    object.productName(reader.readString());
                    continue block20;
                }
                case "serial_number": {
                    object.serialNumber(reader.readString());
                    continue block20;
                }
                case "supported_rng_sources": {
                    object.supportedRngSources(XmlRngSourceReader.readMany(reader));
                    continue block20;
                }
                case "uuid": {
                    object.uuid(reader.readString());
                    continue block20;
                }
                case "version": {
                    object.version(reader.readString());
                    continue block20;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block20;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlHardwareInformationReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<HardwareInformation> iterateMany(final XmlReader reader) {
        return new Iterator<HardwareInformation>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public HardwareInformation next() {
                HardwareInformation next = XmlHardwareInformationReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<HardwareInformation> readMany(XmlReader reader) {
        ArrayList<HardwareInformation> list = new ArrayList<HardwareInformation>();
        Iterator<HardwareInformation> iterator = XmlHardwareInformationReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(HardwareInformationContainer object, String[] link) {
    }
}

