/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ExternalVmProviderType {
    KVM("kvm"),
    VMWARE("vmware"),
    XEN("xen");

    private static final Logger log;
    private String image;

    private ExternalVmProviderType(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static ExternalVmProviderType fromValue(String value) {
        try {
            return ExternalVmProviderType.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'ExternalVmProviderType' enumerated type. Valid values are 'kvm', 'vmware' and 'xen'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(ExternalVmProviderType.class);
    }
}

