/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.VnicProfileBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.AssignedVnicProfileServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlVnicProfileReader;
import org.ovirt.engine.sdk4.internal.xml.XmlVnicProfileWriter;
import org.ovirt.engine.sdk4.services.AssignedVnicProfileService;
import org.ovirt.engine.sdk4.services.AssignedVnicProfilesService;
import org.ovirt.engine.sdk4.types.VnicProfile;

public class AssignedVnicProfilesServiceImpl
extends ServiceImpl
implements AssignedVnicProfilesService {
    public AssignedVnicProfilesServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public AssignedVnicProfilesService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public AssignedVnicProfilesService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public AssignedVnicProfileService profileService(String id) {
        return new AssignedVnicProfileServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.profileService(path);
        }
        return this.profileService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "AssignedVnicProfilesService:" + this.getPath();
    }

    private class ListResponseImpl
    implements AssignedVnicProfilesService.ListResponse {
        private List<VnicProfile> profiles;

        private ListResponseImpl() {
        }

        public void profiles(List<VnicProfile> profiles) {
            this.profiles = profiles;
        }

        @Override
        public List<VnicProfile> profiles() {
            return this.profiles;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<AssignedVnicProfilesService.ListRequest, AssignedVnicProfilesService.ListResponse>
    implements AssignedVnicProfilesService.ListRequest {
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public AssignedVnicProfilesService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public AssignedVnicProfilesService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public AssignedVnicProfilesService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public AssignedVnicProfilesService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public AssignedVnicProfilesService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(AssignedVnicProfilesServiceImpl.this.getConnection().getUrl() + AssignedVnicProfilesServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = AssignedVnicProfilesServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.profiles(XmlVnicProfileReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            AssignedVnicProfilesServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements AssignedVnicProfilesService.AddResponse {
        private VnicProfile profile;

        private AddResponseImpl() {
        }

        public void profile(VnicProfile profile) {
            this.profile = profile;
        }

        @Override
        public VnicProfile profile() {
            return this.profile;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<AssignedVnicProfilesService.AddRequest, AssignedVnicProfilesService.AddResponse>
    implements AssignedVnicProfilesService.AddRequest {
        private VnicProfile profile;

        private AddRequestImpl() {
        }

        @Override
        public AssignedVnicProfilesService.AddRequest profile(VnicProfile profile) {
            this.profile = profile;
            return this;
        }

        @Override
        public AssignedVnicProfilesService.AddRequest profile(VnicProfileBuilder profile) {
            this.profile = profile.build();
            return this;
        }

        @Override
        public AssignedVnicProfilesService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(AssignedVnicProfilesServiceImpl.this.getConnection().getUrl() + AssignedVnicProfilesServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlVnicProfileWriter.writeOne(this.profile, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = AssignedVnicProfilesServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.profile(XmlVnicProfileReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            AssignedVnicProfilesServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

