/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ExternalNetworkProviderConfigurationServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlExternalNetworkProviderConfigurationReader;
import org.ovirt.engine.sdk4.services.ExternalNetworkProviderConfigurationService;
import org.ovirt.engine.sdk4.services.ExternalNetworkProviderConfigurationsService;
import org.ovirt.engine.sdk4.types.ExternalNetworkProviderConfiguration;

public class ExternalNetworkProviderConfigurationsServiceImpl
extends ServiceImpl
implements ExternalNetworkProviderConfigurationsService {
    public ExternalNetworkProviderConfigurationsServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public ExternalNetworkProviderConfigurationsService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public ExternalNetworkProviderConfigurationService configurationService(String id) {
        return new ExternalNetworkProviderConfigurationServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.configurationService(path);
        }
        return this.configurationService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "ExternalNetworkProviderConfigurationsService:" + this.getPath();
    }

    private class ListResponseImpl
    implements ExternalNetworkProviderConfigurationsService.ListResponse {
        private List<ExternalNetworkProviderConfiguration> configurations;

        private ListResponseImpl() {
        }

        public void configurations(List<ExternalNetworkProviderConfiguration> configurations) {
            this.configurations = configurations;
        }

        @Override
        public List<ExternalNetworkProviderConfiguration> configurations() {
            return this.configurations;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<ExternalNetworkProviderConfigurationsService.ListRequest, ExternalNetworkProviderConfigurationsService.ListResponse>
    implements ExternalNetworkProviderConfigurationsService.ListRequest {
        private String follow;

        private ListRequestImpl() {
        }

        @Override
        public ExternalNetworkProviderConfigurationsService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public ExternalNetworkProviderConfigurationsService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(ExternalNetworkProviderConfigurationsServiceImpl.this.getConnection().getUrl() + ExternalNetworkProviderConfigurationsServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = ExternalNetworkProviderConfigurationsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.configurations(XmlExternalNetworkProviderConfigurationReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            ExternalNetworkProviderConfigurationsServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }
}

