/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.ActionBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlActionWriter;
import org.ovirt.engine.sdk4.internal.xml.XmlImageTransferReader;
import org.ovirt.engine.sdk4.services.ImageTransferService;
import org.ovirt.engine.sdk4.types.Action;
import org.ovirt.engine.sdk4.types.ImageTransfer;

public class ImageTransferServiceImpl
extends ServiceImpl
implements ImageTransferService {
    public ImageTransferServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public ImageTransferService.CancelRequest cancel() {
        return new CancelRequestImpl();
    }

    @Override
    public ImageTransferService.ExtendRequest extend() {
        return new ExtendRequestImpl();
    }

    @Override
    public ImageTransferService.FinalizeRequest finalize_() {
        return new FinalizeRequestImpl();
    }

    @Override
    public ImageTransferService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public ImageTransferService.PauseRequest pause() {
        return new PauseRequestImpl();
    }

    @Override
    public ImageTransferService.ResumeRequest resume() {
        return new ResumeRequestImpl();
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "ImageTransferService:" + this.getPath();
    }

    private class ResumeResponseImpl
    implements ImageTransferService.ResumeResponse {
        private ResumeResponseImpl() {
        }
    }

    private class ResumeRequestImpl
    extends BaseRequest<ImageTransferService.ResumeRequest, ImageTransferService.ResumeResponse>
    implements ImageTransferService.ResumeRequest {
        private ResumeRequestImpl() {
        }

        @Override
        public ImageTransferService.ResumeResponse send() {
            HttpPost request = new HttpPost(ImageTransferServiceImpl.this.getConnection().getUrl() + ImageTransferServiceImpl.this.getPath() + "/resume");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = ImageTransferServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = ImageTransferServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new ResumeResponseImpl();
        }
    }

    private class PauseResponseImpl
    implements ImageTransferService.PauseResponse {
        private PauseResponseImpl() {
        }
    }

    private class PauseRequestImpl
    extends BaseRequest<ImageTransferService.PauseRequest, ImageTransferService.PauseResponse>
    implements ImageTransferService.PauseRequest {
        private PauseRequestImpl() {
        }

        @Override
        public ImageTransferService.PauseResponse send() {
            HttpPost request = new HttpPost(ImageTransferServiceImpl.this.getConnection().getUrl() + ImageTransferServiceImpl.this.getPath() + "/pause");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = ImageTransferServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = ImageTransferServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new PauseResponseImpl();
        }
    }

    private class GetResponseImpl
    implements ImageTransferService.GetResponse {
        private ImageTransfer imageTransfer;

        private GetResponseImpl() {
        }

        public void imageTransfer(ImageTransfer imageTransfer) {
            this.imageTransfer = imageTransfer;
        }

        @Override
        public ImageTransfer imageTransfer() {
            return this.imageTransfer;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<ImageTransferService.GetRequest, ImageTransferService.GetResponse>
    implements ImageTransferService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public ImageTransferService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public ImageTransferService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(ImageTransferServiceImpl.this.getConnection().getUrl() + ImageTransferServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = ImageTransferServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.imageTransfer(XmlImageTransferReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            ImageTransferServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }

    private class FinalizeResponseImpl
    implements ImageTransferService.FinalizeResponse {
        private FinalizeResponseImpl() {
        }
    }

    private class FinalizeRequestImpl
    extends BaseRequest<ImageTransferService.FinalizeRequest, ImageTransferService.FinalizeResponse>
    implements ImageTransferService.FinalizeRequest {
        private FinalizeRequestImpl() {
        }

        @Override
        public ImageTransferService.FinalizeResponse send() {
            HttpPost request = new HttpPost(ImageTransferServiceImpl.this.getConnection().getUrl() + ImageTransferServiceImpl.this.getPath() + "/finalize");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = ImageTransferServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = ImageTransferServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new FinalizeResponseImpl();
        }
    }

    private class ExtendResponseImpl
    implements ImageTransferService.ExtendResponse {
        private ExtendResponseImpl() {
        }
    }

    private class ExtendRequestImpl
    extends BaseRequest<ImageTransferService.ExtendRequest, ImageTransferService.ExtendResponse>
    implements ImageTransferService.ExtendRequest {
        private ExtendRequestImpl() {
        }

        @Override
        public ImageTransferService.ExtendResponse send() {
            HttpPost request = new HttpPost(ImageTransferServiceImpl.this.getConnection().getUrl() + ImageTransferServiceImpl.this.getPath() + "/extend");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = ImageTransferServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = ImageTransferServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new ExtendResponseImpl();
        }
    }

    private class CancelResponseImpl
    implements ImageTransferService.CancelResponse {
        private CancelResponseImpl() {
        }
    }

    private class CancelRequestImpl
    extends BaseRequest<ImageTransferService.CancelRequest, ImageTransferService.CancelResponse>
    implements ImageTransferService.CancelRequest {
        private CancelRequestImpl() {
        }

        @Override
        public ImageTransferService.CancelResponse send() {
            HttpPost request = new HttpPost(ImageTransferServiceImpl.this.getConnection().getUrl() + ImageTransferServiceImpl.this.getPath() + "/cancel");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = ImageTransferServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = ImageTransferServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new CancelResponseImpl();
        }
    }
}

