/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.MacPoolBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlMacPoolReader;
import org.ovirt.engine.sdk4.internal.xml.XmlMacPoolWriter;
import org.ovirt.engine.sdk4.services.MacPoolService;
import org.ovirt.engine.sdk4.types.MacPool;

public class MacPoolServiceImpl
extends ServiceImpl
implements MacPoolService {
    public MacPoolServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public MacPoolService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public MacPoolService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public MacPoolService.UpdateRequest update() {
        return new UpdateRequestImpl();
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "MacPoolService:" + this.getPath();
    }

    private class UpdateResponseImpl
    implements MacPoolService.UpdateResponse {
        private MacPool pool;

        private UpdateResponseImpl() {
        }

        public void pool(MacPool pool) {
            this.pool = pool;
        }

        @Override
        public MacPool pool() {
            return this.pool;
        }
    }

    private class UpdateRequestImpl
    extends BaseRequest<MacPoolService.UpdateRequest, MacPoolService.UpdateResponse>
    implements MacPoolService.UpdateRequest {
        private Boolean async;
        private MacPool pool;

        private UpdateRequestImpl() {
        }

        @Override
        public MacPoolService.UpdateRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public MacPoolService.UpdateRequest pool(MacPool pool) {
            this.pool = pool;
            return this;
        }

        @Override
        public MacPoolService.UpdateRequest pool(MacPoolBuilder pool) {
            this.pool = pool.build();
            return this;
        }

        @Override
        public MacPoolService.UpdateResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(MacPoolServiceImpl.this.getConnection().getUrl() + MacPoolServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlMacPoolWriter.writeOne(this.pool, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = MacPoolServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateResponseImpl actionResponse = new UpdateResponseImpl();
                        actionResponse.pool(XmlMacPoolReader.readOne(reader));
                        UpdateResponseImpl updateResponseImpl = actionResponse;
                        reader.close();
                        return updateResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            MacPoolServiceImpl.this.checkFault(response);
            return new UpdateResponseImpl();
        }
    }

    private class RemoveResponseImpl
    implements MacPoolService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<MacPoolService.RemoveRequest, MacPoolService.RemoveResponse>
    implements MacPoolService.RemoveRequest {
        private Boolean async;

        private RemoveRequestImpl() {
        }

        @Override
        public MacPoolService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public MacPoolService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(MacPoolServiceImpl.this.getConnection().getUrl() + MacPoolServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = MacPoolServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            MacPoolServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class GetResponseImpl
    implements MacPoolService.GetResponse {
        private MacPool pool;

        private GetResponseImpl() {
        }

        public void pool(MacPool pool) {
            this.pool = pool;
        }

        @Override
        public MacPool pool() {
            return this.pool;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<MacPoolService.GetRequest, MacPoolService.GetResponse>
    implements MacPoolService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public MacPoolService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public MacPoolService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(MacPoolServiceImpl.this.getConnection().getUrl() + MacPoolServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = MacPoolServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.pool(XmlMacPoolReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            MacPoolServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

