/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskAttachmentReader;
import org.ovirt.engine.sdk4.services.TemplateDiskAttachmentService;
import org.ovirt.engine.sdk4.types.DiskAttachment;

public class TemplateDiskAttachmentServiceImpl
extends ServiceImpl
implements TemplateDiskAttachmentService {
    public TemplateDiskAttachmentServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public TemplateDiskAttachmentService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public TemplateDiskAttachmentService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "TemplateDiskAttachmentService:" + this.getPath();
    }

    private class RemoveResponseImpl
    implements TemplateDiskAttachmentService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<TemplateDiskAttachmentService.RemoveRequest, TemplateDiskAttachmentService.RemoveResponse>
    implements TemplateDiskAttachmentService.RemoveRequest {
        private Boolean force;
        private String storageDomain;

        private RemoveRequestImpl() {
        }

        @Override
        public TemplateDiskAttachmentService.RemoveRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        @Override
        public TemplateDiskAttachmentService.RemoveRequest storageDomain(String storageDomain) {
            this.storageDomain = storageDomain;
            return this;
        }

        @Override
        public TemplateDiskAttachmentService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(TemplateDiskAttachmentServiceImpl.this.getConnection().getUrl() + TemplateDiskAttachmentServiceImpl.this.getPath());
                if (this.force != null) {
                    uriBuilder.addParameter("force", XmlWriter.renderBoolean(this.force));
                }
                if (this.storageDomain != null) {
                    uriBuilder.addParameter("storage_domain", XmlWriter.renderString(this.storageDomain));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = TemplateDiskAttachmentServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            TemplateDiskAttachmentServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class GetResponseImpl
    implements TemplateDiskAttachmentService.GetResponse {
        private DiskAttachment attachment;

        private GetResponseImpl() {
        }

        public void attachment(DiskAttachment attachment) {
            this.attachment = attachment;
        }

        @Override
        public DiskAttachment attachment() {
            return this.attachment;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<TemplateDiskAttachmentService.GetRequest, TemplateDiskAttachmentService.GetResponse>
    implements TemplateDiskAttachmentService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public TemplateDiskAttachmentService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public TemplateDiskAttachmentService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(TemplateDiskAttachmentServiceImpl.this.getConnection().getUrl() + TemplateDiskAttachmentServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = TemplateDiskAttachmentServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.attachment(XmlDiskAttachmentReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            TemplateDiskAttachmentServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

