/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.ActionBuilder;
import org.ovirt.engine.sdk4.builders.NicBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.MeasurableServiceImpl;
import org.ovirt.engine.sdk4.internal.services.NicNetworkFilterParametersServiceImpl;
import org.ovirt.engine.sdk4.internal.services.StatisticsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.VmReportedDevicesServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlActionWriter;
import org.ovirt.engine.sdk4.internal.xml.XmlNicReader;
import org.ovirt.engine.sdk4.internal.xml.XmlNicWriter;
import org.ovirt.engine.sdk4.services.NicNetworkFilterParametersService;
import org.ovirt.engine.sdk4.services.StatisticsService;
import org.ovirt.engine.sdk4.services.VmNicService;
import org.ovirt.engine.sdk4.services.VmReportedDevicesService;
import org.ovirt.engine.sdk4.types.Action;
import org.ovirt.engine.sdk4.types.Nic;

public class VmNicServiceImpl
extends MeasurableServiceImpl
implements VmNicService {
    public VmNicServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public VmNicService.ActivateRequest activate() {
        return new ActivateRequestImpl();
    }

    @Override
    public VmNicService.DeactivateRequest deactivate() {
        return new DeactivateRequestImpl();
    }

    @Override
    public VmNicService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public VmNicService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public VmNicService.UpdateRequest update() {
        return new UpdateRequestImpl();
    }

    @Override
    public NicNetworkFilterParametersService networkFilterParametersService() {
        return new NicNetworkFilterParametersServiceImpl(this.getConnection(), this.getPath() + "/networkfilterparameters");
    }

    @Override
    public VmReportedDevicesService reportedDevicesService() {
        return new VmReportedDevicesServiceImpl(this.getConnection(), this.getPath() + "/reporteddevices");
    }

    @Override
    public StatisticsService statisticsService() {
        return new StatisticsServiceImpl(this.getConnection(), this.getPath() + "/statistics");
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        if (path.equals("networkfilterparameters")) {
            return this.networkFilterParametersService();
        }
        if (path.startsWith("networkfilterparameters/")) {
            return this.networkFilterParametersService().service(path.substring(24));
        }
        if (path.equals("reporteddevices")) {
            return this.reportedDevicesService();
        }
        if (path.startsWith("reporteddevices/")) {
            return this.reportedDevicesService().service(path.substring(16));
        }
        if (path.equals("statistics")) {
            return this.statisticsService();
        }
        if (path.startsWith("statistics/")) {
            return this.statisticsService().service(path.substring(11));
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    @Override
    public String toString() {
        return "VmNicService:" + this.getPath();
    }

    private class UpdateResponseImpl
    implements VmNicService.UpdateResponse {
        private Nic nic;

        private UpdateResponseImpl() {
        }

        public void nic(Nic nic) {
            this.nic = nic;
        }

        @Override
        public Nic nic() {
            return this.nic;
        }
    }

    private class UpdateRequestImpl
    extends BaseRequest<VmNicService.UpdateRequest, VmNicService.UpdateResponse>
    implements VmNicService.UpdateRequest {
        private Boolean async;
        private Nic nic;

        private UpdateRequestImpl() {
        }

        @Override
        public VmNicService.UpdateRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public VmNicService.UpdateRequest nic(Nic nic) {
            this.nic = nic;
            return this;
        }

        @Override
        public VmNicService.UpdateRequest nic(NicBuilder nic) {
            this.nic = nic.build();
            return this;
        }

        @Override
        public VmNicService.UpdateResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VmNicServiceImpl.this.getConnection().getUrl() + VmNicServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlNicWriter.writeOne(this.nic, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VmNicServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateResponseImpl actionResponse = new UpdateResponseImpl();
                        actionResponse.nic(XmlNicReader.readOne(reader));
                        UpdateResponseImpl updateResponseImpl = actionResponse;
                        reader.close();
                        return updateResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            VmNicServiceImpl.this.checkFault(response);
            return new UpdateResponseImpl();
        }
    }

    private class RemoveResponseImpl
    implements VmNicService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<VmNicService.RemoveRequest, VmNicService.RemoveResponse>
    implements VmNicService.RemoveRequest {
        private Boolean async;

        private RemoveRequestImpl() {
        }

        @Override
        public VmNicService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public VmNicService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VmNicServiceImpl.this.getConnection().getUrl() + VmNicServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VmNicServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            VmNicServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class GetResponseImpl
    implements VmNicService.GetResponse {
        private Nic nic;

        private GetResponseImpl() {
        }

        public void nic(Nic nic) {
            this.nic = nic;
        }

        @Override
        public Nic nic() {
            return this.nic;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<VmNicService.GetRequest, VmNicService.GetResponse>
    implements VmNicService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public VmNicService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public VmNicService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VmNicServiceImpl.this.getConnection().getUrl() + VmNicServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VmNicServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.nic(XmlNicReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            VmNicServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }

    private class DeactivateResponseImpl
    implements VmNicService.DeactivateResponse {
        private DeactivateResponseImpl() {
        }
    }

    private class DeactivateRequestImpl
    extends BaseRequest<VmNicService.DeactivateRequest, VmNicService.DeactivateResponse>
    implements VmNicService.DeactivateRequest {
        private Boolean async;

        private DeactivateRequestImpl() {
        }

        @Override
        public VmNicService.DeactivateRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public VmNicService.DeactivateResponse send() {
            HttpPost request = new HttpPost(VmNicServiceImpl.this.getConnection().getUrl() + VmNicServiceImpl.this.getPath() + "/deactivate");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.async(this.async);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = VmNicServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = VmNicServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new DeactivateResponseImpl();
        }
    }

    private class ActivateResponseImpl
    implements VmNicService.ActivateResponse {
        private ActivateResponseImpl() {
        }
    }

    private class ActivateRequestImpl
    extends BaseRequest<VmNicService.ActivateRequest, VmNicService.ActivateResponse>
    implements VmNicService.ActivateRequest {
        private Boolean async;

        private ActivateRequestImpl() {
        }

        @Override
        public VmNicService.ActivateRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public VmNicService.ActivateResponse send() {
            HttpPost request = new HttpPost(VmNicServiceImpl.this.getConnection().getUrl() + VmNicServiceImpl.this.getPath() + "/activate");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.async(this.async);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = VmNicServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = VmNicServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new ActivateResponseImpl();
        }
    }
}

