/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;

import java.lang.String;
import java.math.BigInteger;
import java.util.List;

public interface GlusterHook extends Identified {
    String checksum();
    
    boolean checksumPresent();
    
    BigInteger conflictStatus();
    Byte conflictStatusAsByte();
    Short conflictStatusAsShort();
    Integer conflictStatusAsInteger();
    Long conflictStatusAsLong();
    
    boolean conflictStatusPresent();
    
    String conflicts();
    
    boolean conflictsPresent();
    
    String content();
    
    boolean contentPresent();
    
    HookContentType contentType();
    
    boolean contentTypePresent();
    
    String glusterCommand();
    
    boolean glusterCommandPresent();
    
    HookStage stage();
    
    boolean stagePresent();
    
    GlusterHookStatus status();
    
    boolean statusPresent();
    
    Cluster cluster();
    
    boolean clusterPresent();
    
    List<GlusterServerHook> serverHooks();
    
    boolean serverHooksPresent();
    
}
