/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;

import java.lang.String;
import java.math.BigInteger;

public interface GlusterMemoryPool extends Identified {
    BigInteger allocCount();
    Byte allocCountAsByte();
    Short allocCountAsShort();
    Integer allocCountAsInteger();
    Long allocCountAsLong();
    
    boolean allocCountPresent();
    
    BigInteger coldCount();
    Byte coldCountAsByte();
    Short coldCountAsShort();
    Integer coldCountAsInteger();
    Long coldCountAsLong();
    
    boolean coldCountPresent();
    
    BigInteger hotCount();
    Byte hotCountAsByte();
    Short hotCountAsShort();
    Integer hotCountAsInteger();
    Long hotCountAsLong();
    
    boolean hotCountPresent();
    
    BigInteger maxAlloc();
    Byte maxAllocAsByte();
    Short maxAllocAsShort();
    Integer maxAllocAsInteger();
    Long maxAllocAsLong();
    
    boolean maxAllocPresent();
    
    BigInteger maxStdalloc();
    Byte maxStdallocAsByte();
    Short maxStdallocAsShort();
    Integer maxStdallocAsInteger();
    Long maxStdallocAsLong();
    
    boolean maxStdallocPresent();
    
    BigInteger paddedSize();
    Byte paddedSizeAsByte();
    Short paddedSizeAsShort();
    Integer paddedSizeAsInteger();
    Long paddedSizeAsLong();
    
    boolean paddedSizePresent();
    
    BigInteger poolMisses();
    Byte poolMissesAsByte();
    Short poolMissesAsShort();
    Integer poolMissesAsInteger();
    Long poolMissesAsLong();
    
    boolean poolMissesPresent();
    
    String type();
    
    boolean typePresent();
    
}
