/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.InstanceTypeBuilder;
import org.ovirt.engine.sdk4.builders.TemplateBuilder;
import org.ovirt.engine.sdk4.builders.VmBuilder;
import org.ovirt.engine.sdk4.internal.containers.DeviceContainer;
import org.ovirt.engine.sdk4.types.Device;
import org.ovirt.engine.sdk4.types.InstanceType;
import org.ovirt.engine.sdk4.types.Template;
import org.ovirt.engine.sdk4.types.Vm;

public class DeviceBuilder {
    private String comment;
    private String description;
    private String href;
    private String id;
    private InstanceType instanceType;
    private String name;
    private Template template;
    private Vm vm;
    private List<Vm> vms;

    public DeviceBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public DeviceBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public DeviceBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public DeviceBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public DeviceBuilder instanceType(InstanceType newInstanceType) {
        this.instanceType = newInstanceType;
        return this;
    }

    public DeviceBuilder instanceType(InstanceTypeBuilder newInstanceType) {
        this.instanceType = newInstanceType == null ? null : newInstanceType.build();
        return this;
    }

    public DeviceBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public DeviceBuilder template(Template newTemplate) {
        this.template = newTemplate;
        return this;
    }

    public DeviceBuilder template(TemplateBuilder newTemplate) {
        this.template = newTemplate == null ? null : newTemplate.build();
        return this;
    }

    public DeviceBuilder vm(Vm newVm) {
        this.vm = newVm;
        return this;
    }

    public DeviceBuilder vm(VmBuilder newVm) {
        this.vm = newVm == null ? null : newVm.build();
        return this;
    }

    public DeviceBuilder vms(List<Vm> newVms) {
        if (newVms != null) {
            if (this.vms == null) {
                this.vms = new ArrayList<Vm>(newVms);
            } else {
                this.vms.addAll(newVms);
            }
        }
        return this;
    }

    public DeviceBuilder vms(Vm ... newVms) {
        if (newVms != null) {
            if (this.vms == null) {
                this.vms = new ArrayList<Vm>(newVms.length);
            }
            Collections.addAll(this.vms, newVms);
        }
        return this;
    }

    public DeviceBuilder vms(VmBuilder ... newVms) {
        if (newVms != null) {
            if (this.vms == null) {
                this.vms = new ArrayList<Vm>(newVms.length);
            }
            for (VmBuilder builder : newVms) {
                this.vms.add(builder.build());
            }
        }
        return this;
    }

    public Device build() {
        DeviceContainer container = new DeviceContainer();
        container.comment(this.comment);
        container.description(this.description);
        container.href(this.href);
        container.id(this.id);
        container.instanceType(this.instanceType);
        container.name(this.name);
        container.template(this.template);
        container.vm(this.vm);
        container.vms(this.vms);
        return container;
    }
}

