/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ClusterLevelServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlClusterLevelReader;
import org.ovirt.engine.sdk4.services.ClusterLevelService;
import org.ovirt.engine.sdk4.services.ClusterLevelsService;
import org.ovirt.engine.sdk4.types.ClusterLevel;

public class ClusterLevelsServiceImpl
extends ServiceImpl
implements ClusterLevelsService {
    public ClusterLevelsServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public ClusterLevelsService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public ClusterLevelService levelService(String id) {
        return new ClusterLevelServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.levelService(path);
        }
        return this.levelService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "ClusterLevelsService:" + this.getPath();
    }

    private class ListResponseImpl
    implements ClusterLevelsService.ListResponse {
        private List<ClusterLevel> levels;

        private ListResponseImpl() {
        }

        public void levels(List<ClusterLevel> levels) {
            this.levels = levels;
        }

        @Override
        public List<ClusterLevel> levels() {
            return this.levels;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<ClusterLevelsService.ListRequest, ClusterLevelsService.ListResponse>
    implements ClusterLevelsService.ListRequest {
        private String follow;

        private ListRequestImpl() {
        }

        @Override
        public ClusterLevelsService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public ClusterLevelsService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(ClusterLevelsServiceImpl.this.getConnection().getUrl() + ClusterLevelsServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = ClusterLevelsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.levels(XmlClusterLevelReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            ClusterLevelsServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }
}

