/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.ActionBuilder;
import org.ovirt.engine.sdk4.builders.ClusterBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.AffinityGroupsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.AssignedCpuProfilesServiceImpl;
import org.ovirt.engine.sdk4.internal.services.AssignedPermissionsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ClusterEnabledFeaturesServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ClusterExternalProvidersServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ClusterNetworksServiceImpl;
import org.ovirt.engine.sdk4.internal.services.GlusterHooksServiceImpl;
import org.ovirt.engine.sdk4.internal.services.GlusterVolumesServiceImpl;
import org.ovirt.engine.sdk4.internal.services.NetworkFiltersServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlActionWriter;
import org.ovirt.engine.sdk4.internal.xml.XmlClusterReader;
import org.ovirt.engine.sdk4.internal.xml.XmlClusterWriter;
import org.ovirt.engine.sdk4.services.AffinityGroupsService;
import org.ovirt.engine.sdk4.services.AssignedCpuProfilesService;
import org.ovirt.engine.sdk4.services.AssignedPermissionsService;
import org.ovirt.engine.sdk4.services.ClusterEnabledFeaturesService;
import org.ovirt.engine.sdk4.services.ClusterExternalProvidersService;
import org.ovirt.engine.sdk4.services.ClusterNetworksService;
import org.ovirt.engine.sdk4.services.ClusterService;
import org.ovirt.engine.sdk4.services.GlusterHooksService;
import org.ovirt.engine.sdk4.services.GlusterVolumesService;
import org.ovirt.engine.sdk4.services.NetworkFiltersService;
import org.ovirt.engine.sdk4.types.Action;
import org.ovirt.engine.sdk4.types.Cluster;
import org.ovirt.engine.sdk4.types.ClusterUpgradeAction;

public class ClusterServiceImpl
extends ServiceImpl
implements ClusterService {
    public ClusterServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public ClusterService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public ClusterService.RefreshGlusterHealStatusRequest refreshGlusterHealStatus() {
        return new RefreshGlusterHealStatusRequestImpl();
    }

    @Override
    public ClusterService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public ClusterService.ResetEmulatedMachineRequest resetEmulatedMachine() {
        return new ResetEmulatedMachineRequestImpl();
    }

    @Override
    public ClusterService.SyncAllNetworksRequest syncAllNetworks() {
        return new SyncAllNetworksRequestImpl();
    }

    @Override
    public ClusterService.UpdateRequest update() {
        return new UpdateRequestImpl();
    }

    @Override
    public ClusterService.UpgradeRequest upgrade() {
        return new UpgradeRequestImpl();
    }

    @Override
    public AffinityGroupsService affinityGroupsService() {
        return new AffinityGroupsServiceImpl(this.getConnection(), this.getPath() + "/affinitygroups");
    }

    @Override
    public AssignedCpuProfilesService cpuProfilesService() {
        return new AssignedCpuProfilesServiceImpl(this.getConnection(), this.getPath() + "/cpuprofiles");
    }

    @Override
    public ClusterEnabledFeaturesService enabledFeaturesService() {
        return new ClusterEnabledFeaturesServiceImpl(this.getConnection(), this.getPath() + "/enabledfeatures");
    }

    @Override
    public ClusterExternalProvidersService externalNetworkProvidersService() {
        return new ClusterExternalProvidersServiceImpl(this.getConnection(), this.getPath() + "/externalnetworkproviders");
    }

    @Override
    public GlusterHooksService glusterHooksService() {
        return new GlusterHooksServiceImpl(this.getConnection(), this.getPath() + "/glusterhooks");
    }

    @Override
    public GlusterVolumesService glusterVolumesService() {
        return new GlusterVolumesServiceImpl(this.getConnection(), this.getPath() + "/glustervolumes");
    }

    @Override
    public NetworkFiltersService networkFiltersService() {
        return new NetworkFiltersServiceImpl(this.getConnection(), this.getPath() + "/networkfilters");
    }

    @Override
    public ClusterNetworksService networksService() {
        return new ClusterNetworksServiceImpl(this.getConnection(), this.getPath() + "/networks");
    }

    @Override
    public AssignedPermissionsService permissionsService() {
        return new AssignedPermissionsServiceImpl(this.getConnection(), this.getPath() + "/permissions");
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        if (path.equals("affinitygroups")) {
            return this.affinityGroupsService();
        }
        if (path.startsWith("affinitygroups/")) {
            return this.affinityGroupsService().service(path.substring(15));
        }
        if (path.equals("cpuprofiles")) {
            return this.cpuProfilesService();
        }
        if (path.startsWith("cpuprofiles/")) {
            return this.cpuProfilesService().service(path.substring(12));
        }
        if (path.equals("enabledfeatures")) {
            return this.enabledFeaturesService();
        }
        if (path.startsWith("enabledfeatures/")) {
            return this.enabledFeaturesService().service(path.substring(16));
        }
        if (path.equals("externalnetworkproviders")) {
            return this.externalNetworkProvidersService();
        }
        if (path.startsWith("externalnetworkproviders/")) {
            return this.externalNetworkProvidersService().service(path.substring(25));
        }
        if (path.equals("glusterhooks")) {
            return this.glusterHooksService();
        }
        if (path.startsWith("glusterhooks/")) {
            return this.glusterHooksService().service(path.substring(13));
        }
        if (path.equals("glustervolumes")) {
            return this.glusterVolumesService();
        }
        if (path.startsWith("glustervolumes/")) {
            return this.glusterVolumesService().service(path.substring(15));
        }
        if (path.equals("networkfilters")) {
            return this.networkFiltersService();
        }
        if (path.startsWith("networkfilters/")) {
            return this.networkFiltersService().service(path.substring(15));
        }
        if (path.equals("networks")) {
            return this.networksService();
        }
        if (path.startsWith("networks/")) {
            return this.networksService().service(path.substring(9));
        }
        if (path.equals("permissions")) {
            return this.permissionsService();
        }
        if (path.startsWith("permissions/")) {
            return this.permissionsService().service(path.substring(12));
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "ClusterService:" + this.getPath();
    }

    private class UpgradeResponseImpl
    implements ClusterService.UpgradeResponse {
        private UpgradeResponseImpl() {
        }
    }

    private class UpgradeRequestImpl
    extends BaseRequest<ClusterService.UpgradeRequest, ClusterService.UpgradeResponse>
    implements ClusterService.UpgradeRequest {
        private Boolean async;
        private ClusterUpgradeAction upgradeAction;

        private UpgradeRequestImpl() {
        }

        @Override
        public ClusterService.UpgradeRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        public ClusterService.UpgradeRequest upgradeAction(ClusterUpgradeAction upgradeAction) {
            this.upgradeAction = upgradeAction;
            return this;
        }

        @Override
        public ClusterService.UpgradeResponse send() {
            HttpPost request = new HttpPost(ClusterServiceImpl.this.getConnection().getUrl() + ClusterServiceImpl.this.getPath() + "/upgrade");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.async(this.async);
                action.upgradeAction(this.upgradeAction);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = ClusterServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = ClusterServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new UpgradeResponseImpl();
        }
    }

    private class UpdateResponseImpl
    implements ClusterService.UpdateResponse {
        private Cluster cluster;

        private UpdateResponseImpl() {
        }

        public void cluster(Cluster cluster) {
            this.cluster = cluster;
        }

        @Override
        public Cluster cluster() {
            return this.cluster;
        }
    }

    private class UpdateRequestImpl
    extends BaseRequest<ClusterService.UpdateRequest, ClusterService.UpdateResponse>
    implements ClusterService.UpdateRequest {
        private Boolean async;
        private Cluster cluster;

        private UpdateRequestImpl() {
        }

        @Override
        public ClusterService.UpdateRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public ClusterService.UpdateRequest cluster(Cluster cluster) {
            this.cluster = cluster;
            return this;
        }

        @Override
        public ClusterService.UpdateRequest cluster(ClusterBuilder cluster) {
            this.cluster = cluster.build();
            return this;
        }

        @Override
        public ClusterService.UpdateResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(ClusterServiceImpl.this.getConnection().getUrl() + ClusterServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlClusterWriter.writeOne(this.cluster, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = ClusterServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateResponseImpl actionResponse = new UpdateResponseImpl();
                        actionResponse.cluster(XmlClusterReader.readOne(reader));
                        UpdateResponseImpl updateResponseImpl = actionResponse;
                        reader.close();
                        return updateResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            ClusterServiceImpl.this.checkFault(response);
            return new UpdateResponseImpl();
        }
    }

    private class SyncAllNetworksResponseImpl
    implements ClusterService.SyncAllNetworksResponse {
        private SyncAllNetworksResponseImpl() {
        }
    }

    private class SyncAllNetworksRequestImpl
    extends BaseRequest<ClusterService.SyncAllNetworksRequest, ClusterService.SyncAllNetworksResponse>
    implements ClusterService.SyncAllNetworksRequest {
        private Boolean async;

        private SyncAllNetworksRequestImpl() {
        }

        @Override
        public ClusterService.SyncAllNetworksRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public ClusterService.SyncAllNetworksResponse send() {
            HttpPost request = new HttpPost(ClusterServiceImpl.this.getConnection().getUrl() + ClusterServiceImpl.this.getPath() + "/syncallnetworks");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.async(this.async);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = ClusterServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = ClusterServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new SyncAllNetworksResponseImpl();
        }
    }

    private class ResetEmulatedMachineResponseImpl
    implements ClusterService.ResetEmulatedMachineResponse {
        private ResetEmulatedMachineResponseImpl() {
        }
    }

    private class ResetEmulatedMachineRequestImpl
    extends BaseRequest<ClusterService.ResetEmulatedMachineRequest, ClusterService.ResetEmulatedMachineResponse>
    implements ClusterService.ResetEmulatedMachineRequest {
        private Boolean async;

        private ResetEmulatedMachineRequestImpl() {
        }

        @Override
        public ClusterService.ResetEmulatedMachineRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public ClusterService.ResetEmulatedMachineResponse send() {
            HttpPost request = new HttpPost(ClusterServiceImpl.this.getConnection().getUrl() + ClusterServiceImpl.this.getPath() + "/resetemulatedmachine");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.async(this.async);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = ClusterServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = ClusterServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new ResetEmulatedMachineResponseImpl();
        }
    }

    private class RemoveResponseImpl
    implements ClusterService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<ClusterService.RemoveRequest, ClusterService.RemoveResponse>
    implements ClusterService.RemoveRequest {
        private Boolean async;

        private RemoveRequestImpl() {
        }

        @Override
        public ClusterService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public ClusterService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(ClusterServiceImpl.this.getConnection().getUrl() + ClusterServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = ClusterServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            ClusterServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class RefreshGlusterHealStatusResponseImpl
    implements ClusterService.RefreshGlusterHealStatusResponse {
        private RefreshGlusterHealStatusResponseImpl() {
        }
    }

    private class RefreshGlusterHealStatusRequestImpl
    extends BaseRequest<ClusterService.RefreshGlusterHealStatusRequest, ClusterService.RefreshGlusterHealStatusResponse>
    implements ClusterService.RefreshGlusterHealStatusRequest {
        private RefreshGlusterHealStatusRequestImpl() {
        }

        @Override
        public ClusterService.RefreshGlusterHealStatusResponse send() {
            HttpPost request = new HttpPost(ClusterServiceImpl.this.getConnection().getUrl() + ClusterServiceImpl.this.getPath() + "/refreshglusterhealstatus");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = ClusterServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = ClusterServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new RefreshGlusterHealStatusResponseImpl();
        }
    }

    private class GetResponseImpl
    implements ClusterService.GetResponse {
        private Cluster cluster;

        private GetResponseImpl() {
        }

        public void cluster(Cluster cluster) {
            this.cluster = cluster;
        }

        @Override
        public Cluster cluster() {
            return this.cluster;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<ClusterService.GetRequest, ClusterService.GetResponse>
    implements ClusterService.GetRequest {
        private Boolean filter;
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public ClusterService.GetRequest filter(Boolean filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public ClusterService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public ClusterService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(ClusterServiceImpl.this.getConnection().getUrl() + ClusterServiceImpl.this.getPath());
                if (this.filter != null) {
                    uriBuilder.addParameter("filter", XmlWriter.renderBoolean(this.filter));
                }
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = ClusterServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.cluster(XmlClusterReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            ClusterServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

