/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.DiskAttachmentBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.DiskAttachmentServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskAttachmentReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskAttachmentWriter;
import org.ovirt.engine.sdk4.services.DiskAttachmentService;
import org.ovirt.engine.sdk4.services.DiskAttachmentsService;
import org.ovirt.engine.sdk4.types.DiskAttachment;

public class DiskAttachmentsServiceImpl
extends ServiceImpl
implements DiskAttachmentsService {
    public DiskAttachmentsServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public DiskAttachmentsService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public DiskAttachmentsService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public DiskAttachmentsService.AddProvidingDiskIdRequest addProvidingDiskId() {
        return new AddProvidingDiskIdRequestImpl();
    }

    @Override
    public DiskAttachmentsService.AddSignature1Request addSignature1() {
        return new AddSignature1RequestImpl();
    }

    @Override
    public DiskAttachmentService attachmentService(String id) {
        return new DiskAttachmentServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.attachmentService(path);
        }
        return this.attachmentService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "DiskAttachmentsService:" + this.getPath();
    }

    private class AddSignature1ResponseImpl
    implements DiskAttachmentsService.AddSignature1Response {
        private DiskAttachment attachment;

        private AddSignature1ResponseImpl() {
        }

        public void attachment(DiskAttachment attachment) {
            this.attachment = attachment;
        }

        @Override
        public DiskAttachment attachment() {
            return this.attachment;
        }
    }

    private class AddSignature1RequestImpl
    extends BaseRequest<DiskAttachmentsService.AddSignature1Request, DiskAttachmentsService.AddSignature1Response>
    implements DiskAttachmentsService.AddSignature1Request {
        private DiskAttachment attachment;

        private AddSignature1RequestImpl() {
        }

        @Override
        public DiskAttachmentsService.AddSignature1Request attachment(DiskAttachment attachment) {
            this.attachment = attachment;
            return this;
        }

        @Override
        public DiskAttachmentsService.AddSignature1Request attachment(DiskAttachmentBuilder attachment) {
            this.attachment = attachment.build();
            return this;
        }

        @Override
        public DiskAttachmentsService.AddSignature1Response send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(DiskAttachmentsServiceImpl.this.getConnection().getUrl() + DiskAttachmentsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlDiskAttachmentWriter.writeOne(this.attachment, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = DiskAttachmentsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddSignature1ResponseImpl actionResponse = new AddSignature1ResponseImpl();
                        actionResponse.attachment(XmlDiskAttachmentReader.readOne(reader));
                        AddSignature1ResponseImpl addSignature1ResponseImpl = actionResponse;
                        reader.close();
                        return addSignature1ResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            DiskAttachmentsServiceImpl.this.checkFault(response);
            return new AddSignature1ResponseImpl();
        }
    }

    private class AddProvidingDiskIdResponseImpl
    implements DiskAttachmentsService.AddProvidingDiskIdResponse {
        private DiskAttachment attachment;

        private AddProvidingDiskIdResponseImpl() {
        }

        public void attachment(DiskAttachment attachment) {
            this.attachment = attachment;
        }

        @Override
        public DiskAttachment attachment() {
            return this.attachment;
        }
    }

    private class AddProvidingDiskIdRequestImpl
    extends BaseRequest<DiskAttachmentsService.AddProvidingDiskIdRequest, DiskAttachmentsService.AddProvidingDiskIdResponse>
    implements DiskAttachmentsService.AddProvidingDiskIdRequest {
        private DiskAttachment attachment;

        private AddProvidingDiskIdRequestImpl() {
        }

        @Override
        public DiskAttachmentsService.AddProvidingDiskIdRequest attachment(DiskAttachment attachment) {
            this.attachment = attachment;
            return this;
        }

        @Override
        public DiskAttachmentsService.AddProvidingDiskIdRequest attachment(DiskAttachmentBuilder attachment) {
            this.attachment = attachment.build();
            return this;
        }

        @Override
        public DiskAttachmentsService.AddProvidingDiskIdResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(DiskAttachmentsServiceImpl.this.getConnection().getUrl() + DiskAttachmentsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlDiskAttachmentWriter.writeOne(this.attachment, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = DiskAttachmentsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddProvidingDiskIdResponseImpl actionResponse = new AddProvidingDiskIdResponseImpl();
                        actionResponse.attachment(XmlDiskAttachmentReader.readOne(reader));
                        AddProvidingDiskIdResponseImpl addProvidingDiskIdResponseImpl = actionResponse;
                        reader.close();
                        return addProvidingDiskIdResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            DiskAttachmentsServiceImpl.this.checkFault(response);
            return new AddProvidingDiskIdResponseImpl();
        }
    }

    private class ListResponseImpl
    implements DiskAttachmentsService.ListResponse {
        private List<DiskAttachment> attachments;

        private ListResponseImpl() {
        }

        public void attachments(List<DiskAttachment> attachments) {
            this.attachments = attachments;
        }

        @Override
        public List<DiskAttachment> attachments() {
            return this.attachments;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<DiskAttachmentsService.ListRequest, DiskAttachmentsService.ListResponse>
    implements DiskAttachmentsService.ListRequest {
        private String follow;

        private ListRequestImpl() {
        }

        @Override
        public DiskAttachmentsService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public DiskAttachmentsService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(DiskAttachmentsServiceImpl.this.getConnection().getUrl() + DiskAttachmentsServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = DiskAttachmentsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.attachments(XmlDiskAttachmentReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            DiskAttachmentsServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements DiskAttachmentsService.AddResponse {
        private DiskAttachment attachment;

        private AddResponseImpl() {
        }

        public void attachment(DiskAttachment attachment) {
            this.attachment = attachment;
        }

        @Override
        public DiskAttachment attachment() {
            return this.attachment;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<DiskAttachmentsService.AddRequest, DiskAttachmentsService.AddResponse>
    implements DiskAttachmentsService.AddRequest {
        private DiskAttachment attachment;

        private AddRequestImpl() {
        }

        @Override
        public DiskAttachmentsService.AddRequest attachment(DiskAttachment attachment) {
            this.attachment = attachment;
            return this;
        }

        @Override
        public DiskAttachmentsService.AddRequest attachment(DiskAttachmentBuilder attachment) {
            this.attachment = attachment.build();
            return this;
        }

        @Override
        public DiskAttachmentsService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(DiskAttachmentsServiceImpl.this.getConnection().getUrl() + DiskAttachmentsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlDiskAttachmentWriter.writeOne(this.attachment, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = DiskAttachmentsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.attachment(XmlDiskAttachmentReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            DiskAttachmentsServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

