/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.NetworkAttachmentBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.NetworkAttachmentServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlNetworkAttachmentReader;
import org.ovirt.engine.sdk4.internal.xml.XmlNetworkAttachmentWriter;
import org.ovirt.engine.sdk4.services.NetworkAttachmentService;
import org.ovirt.engine.sdk4.services.NetworkAttachmentsService;
import org.ovirt.engine.sdk4.types.NetworkAttachment;

public class NetworkAttachmentsServiceImpl
extends ServiceImpl
implements NetworkAttachmentsService {
    public NetworkAttachmentsServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public NetworkAttachmentsService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public NetworkAttachmentsService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public NetworkAttachmentService attachmentService(String id) {
        return new NetworkAttachmentServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.attachmentService(path);
        }
        return this.attachmentService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "NetworkAttachmentsService:" + this.getPath();
    }

    private class ListResponseImpl
    implements NetworkAttachmentsService.ListResponse {
        private List<NetworkAttachment> attachments;

        private ListResponseImpl() {
        }

        public void attachments(List<NetworkAttachment> attachments) {
            this.attachments = attachments;
        }

        @Override
        public List<NetworkAttachment> attachments() {
            return this.attachments;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<NetworkAttachmentsService.ListRequest, NetworkAttachmentsService.ListResponse>
    implements NetworkAttachmentsService.ListRequest {
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public NetworkAttachmentsService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public NetworkAttachmentsService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public NetworkAttachmentsService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public NetworkAttachmentsService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public NetworkAttachmentsService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(NetworkAttachmentsServiceImpl.this.getConnection().getUrl() + NetworkAttachmentsServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = NetworkAttachmentsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.attachments(XmlNetworkAttachmentReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            NetworkAttachmentsServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements NetworkAttachmentsService.AddResponse {
        private NetworkAttachment attachment;

        private AddResponseImpl() {
        }

        public void attachment(NetworkAttachment attachment) {
            this.attachment = attachment;
        }

        @Override
        public NetworkAttachment attachment() {
            return this.attachment;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<NetworkAttachmentsService.AddRequest, NetworkAttachmentsService.AddResponse>
    implements NetworkAttachmentsService.AddRequest {
        private NetworkAttachment attachment;

        private AddRequestImpl() {
        }

        @Override
        public NetworkAttachmentsService.AddRequest attachment(NetworkAttachment attachment) {
            this.attachment = attachment;
            return this;
        }

        @Override
        public NetworkAttachmentsService.AddRequest attachment(NetworkAttachmentBuilder attachment) {
            this.attachment = attachment.build();
            return this;
        }

        @Override
        public NetworkAttachmentsService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(NetworkAttachmentsServiceImpl.this.getConnection().getUrl() + NetworkAttachmentsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlNetworkAttachmentWriter.writeOne(this.attachment, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = NetworkAttachmentsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.attachment(XmlNetworkAttachmentReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            NetworkAttachmentsServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

