/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.OperatingSystemServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlOperatingSystemInfoReader;
import org.ovirt.engine.sdk4.services.OperatingSystemService;
import org.ovirt.engine.sdk4.services.OperatingSystemsService;
import org.ovirt.engine.sdk4.types.OperatingSystemInfo;

public class OperatingSystemsServiceImpl
extends ServiceImpl
implements OperatingSystemsService {
    public OperatingSystemsServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public OperatingSystemsService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public OperatingSystemService operatingSystemService(String id) {
        return new OperatingSystemServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.operatingSystemService(path);
        }
        return this.operatingSystemService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "OperatingSystemsService:" + this.getPath();
    }

    private class ListResponseImpl
    implements OperatingSystemsService.ListResponse {
        private List<OperatingSystemInfo> operatingSystem;

        private ListResponseImpl() {
        }

        public void operatingSystem(List<OperatingSystemInfo> operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        public List<OperatingSystemInfo> operatingSystem() {
            return this.operatingSystem;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<OperatingSystemsService.ListRequest, OperatingSystemsService.ListResponse>
    implements OperatingSystemsService.ListRequest {
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public OperatingSystemsService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public OperatingSystemsService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public OperatingSystemsService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public OperatingSystemsService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public OperatingSystemsService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(OperatingSystemsServiceImpl.this.getConnection().getUrl() + OperatingSystemsServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = OperatingSystemsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.operatingSystem(XmlOperatingSystemInfoReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            OperatingSystemsServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }
}

