/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlUnmanagedNetworkReader;
import org.ovirt.engine.sdk4.services.UnmanagedNetworkService;
import org.ovirt.engine.sdk4.types.UnmanagedNetwork;

public class UnmanagedNetworkServiceImpl
extends ServiceImpl
implements UnmanagedNetworkService {
    public UnmanagedNetworkServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public UnmanagedNetworkService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public UnmanagedNetworkService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "UnmanagedNetworkService:" + this.getPath();
    }

    private class RemoveResponseImpl
    implements UnmanagedNetworkService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<UnmanagedNetworkService.RemoveRequest, UnmanagedNetworkService.RemoveResponse>
    implements UnmanagedNetworkService.RemoveRequest {
        private Boolean async;

        private RemoveRequestImpl() {
        }

        @Override
        public UnmanagedNetworkService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public UnmanagedNetworkService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(UnmanagedNetworkServiceImpl.this.getConnection().getUrl() + UnmanagedNetworkServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = UnmanagedNetworkServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            UnmanagedNetworkServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class GetResponseImpl
    implements UnmanagedNetworkService.GetResponse {
        private UnmanagedNetwork network;

        private GetResponseImpl() {
        }

        public void network(UnmanagedNetwork network) {
            this.network = network;
        }

        @Override
        public UnmanagedNetwork network() {
            return this.network;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<UnmanagedNetworkService.GetRequest, UnmanagedNetworkService.GetResponse>
    implements UnmanagedNetworkService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public UnmanagedNetworkService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public UnmanagedNetworkService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(UnmanagedNetworkServiceImpl.this.getConnection().getUrl() + UnmanagedNetworkServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = UnmanagedNetworkServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.network(XmlUnmanagedNetworkReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            UnmanagedNetworkServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

