/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;

import java.math.BigInteger;

/**
 * Describes the virtual functions configuration of an SR-IOV-enabled physical function NIC.
 */
public interface HostNicVirtualFunctionsConfiguration {
    boolean allNetworksAllowed();
    
    boolean allNetworksAllowedPresent();
    
    BigInteger maxNumberOfVirtualFunctions();
    Byte maxNumberOfVirtualFunctionsAsByte();
    Short maxNumberOfVirtualFunctionsAsShort();
    Integer maxNumberOfVirtualFunctionsAsInteger();
    Long maxNumberOfVirtualFunctionsAsLong();
    
    boolean maxNumberOfVirtualFunctionsPresent();
    
    BigInteger numberOfVirtualFunctions();
    Byte numberOfVirtualFunctionsAsByte();
    Short numberOfVirtualFunctionsAsShort();
    Integer numberOfVirtualFunctionsAsInteger();
    Long numberOfVirtualFunctionsAsLong();
    
    boolean numberOfVirtualFunctionsPresent();
    
}
