/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;

import java.math.BigInteger;
import java.util.List;

/**
 * Represents a quota object.
 * 
 * An example XML representation of a quota:
 * 
 * [source,xml]
 * ----
 * <quota href="/ovirt-engine/api/datacenters/7044934e/quotas/dcad5ddc" id="dcad5ddc">
 *   <name>My Quota</name>
 *   <description>A quota for my oVirt environment</description>
 *   <cluster_hard_limit_pct>0</cluster_hard_limit_pct>
 *   <cluster_soft_limit_pct>0</cluster_soft_limit_pct>
 *   <data_center href="/ovirt-engine/api/datacenters/7044934e" id="7044934e"/>
 *   <storage_hard_limit_pct>0</storage_hard_limit_pct>
 *   <storage_soft_limit_pct>0</storage_soft_limit_pct>
 * </quota>
 * ----
 */
public interface Quota extends Identified {
    BigInteger clusterHardLimitPct();
    Byte clusterHardLimitPctAsByte();
    Short clusterHardLimitPctAsShort();
    Integer clusterHardLimitPctAsInteger();
    Long clusterHardLimitPctAsLong();
    
    boolean clusterHardLimitPctPresent();
    
    BigInteger clusterSoftLimitPct();
    Byte clusterSoftLimitPctAsByte();
    Short clusterSoftLimitPctAsShort();
    Integer clusterSoftLimitPctAsInteger();
    Long clusterSoftLimitPctAsLong();
    
    boolean clusterSoftLimitPctPresent();
    
    DataCenter dataCenter();
    
    boolean dataCenterPresent();
    
    List<Disk> disks();
    
    boolean disksPresent();
    
    BigInteger storageHardLimitPct();
    Byte storageHardLimitPctAsByte();
    Short storageHardLimitPctAsShort();
    Integer storageHardLimitPctAsInteger();
    Long storageHardLimitPctAsLong();
    
    boolean storageHardLimitPctPresent();
    
    BigInteger storageSoftLimitPct();
    Byte storageSoftLimitPctAsByte();
    Short storageSoftLimitPctAsShort();
    Integer storageSoftLimitPctAsInteger();
    Long storageSoftLimitPctAsLong();
    
    boolean storageSoftLimitPctPresent();
    
    List<User> users();
    
    boolean usersPresent();
    
    List<Vm> vms();
    
    boolean vmsPresent();
    
    List<Permission> permissions();
    
    boolean permissionsPresent();
    
    List<QuotaClusterLimit> quotaClusterLimits();
    
    boolean quotaClusterLimitsPresent();
    
    List<QuotaStorageLimit> quotaStorageLimits();
    
    boolean quotaStorageLimitsPresent();
    
}
