/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.AffinityGroupBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.AffinityGroupHostLabelsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.AffinityGroupHostsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.AffinityGroupVmLabelsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.AffinityGroupVmsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlAffinityGroupReader;
import org.ovirt.engine.sdk4.internal.xml.XmlAffinityGroupWriter;
import org.ovirt.engine.sdk4.services.AffinityGroupHostLabelsService;
import org.ovirt.engine.sdk4.services.AffinityGroupHostsService;
import org.ovirt.engine.sdk4.services.AffinityGroupService;
import org.ovirt.engine.sdk4.services.AffinityGroupVmLabelsService;
import org.ovirt.engine.sdk4.services.AffinityGroupVmsService;
import org.ovirt.engine.sdk4.types.AffinityGroup;

public class AffinityGroupServiceImpl
extends ServiceImpl
implements AffinityGroupService {
    public AffinityGroupServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public AffinityGroupService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public AffinityGroupService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public AffinityGroupService.UpdateRequest update() {
        return new UpdateRequestImpl();
    }

    @Override
    public AffinityGroupHostLabelsService hostLabelsService() {
        return new AffinityGroupHostLabelsServiceImpl(this.getConnection(), this.getPath() + "/hostlabels");
    }

    @Override
    public AffinityGroupHostsService hostsService() {
        return new AffinityGroupHostsServiceImpl(this.getConnection(), this.getPath() + "/hosts");
    }

    @Override
    public AffinityGroupVmLabelsService vmLabelsService() {
        return new AffinityGroupVmLabelsServiceImpl(this.getConnection(), this.getPath() + "/vmlabels");
    }

    @Override
    public AffinityGroupVmsService vmsService() {
        return new AffinityGroupVmsServiceImpl(this.getConnection(), this.getPath() + "/vms");
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        if (path.equals("hostlabels")) {
            return this.hostLabelsService();
        }
        if (path.startsWith("hostlabels/")) {
            return this.hostLabelsService().service(path.substring(11));
        }
        if (path.equals("hosts")) {
            return this.hostsService();
        }
        if (path.startsWith("hosts/")) {
            return this.hostsService().service(path.substring(6));
        }
        if (path.equals("vmlabels")) {
            return this.vmLabelsService();
        }
        if (path.startsWith("vmlabels/")) {
            return this.vmLabelsService().service(path.substring(9));
        }
        if (path.equals("vms")) {
            return this.vmsService();
        }
        if (path.startsWith("vms/")) {
            return this.vmsService().service(path.substring(4));
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "AffinityGroupService:" + this.getPath();
    }

    private class UpdateResponseImpl
    implements AffinityGroupService.UpdateResponse {
        private AffinityGroup group;

        private UpdateResponseImpl() {
        }

        public void group(AffinityGroup group) {
            this.group = group;
        }

        @Override
        public AffinityGroup group() {
            return this.group;
        }
    }

    private class UpdateRequestImpl
    extends BaseRequest<AffinityGroupService.UpdateRequest, AffinityGroupService.UpdateResponse>
    implements AffinityGroupService.UpdateRequest {
        private Boolean async;
        private AffinityGroup group;

        private UpdateRequestImpl() {
        }

        @Override
        public AffinityGroupService.UpdateRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public AffinityGroupService.UpdateRequest group(AffinityGroup group) {
            this.group = group;
            return this;
        }

        @Override
        public AffinityGroupService.UpdateRequest group(AffinityGroupBuilder group) {
            this.group = group.build();
            return this;
        }

        @Override
        public AffinityGroupService.UpdateResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(AffinityGroupServiceImpl.this.getConnection().getUrl() + AffinityGroupServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlAffinityGroupWriter.writeOne(this.group, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = AffinityGroupServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateResponseImpl actionResponse = new UpdateResponseImpl();
                        actionResponse.group(XmlAffinityGroupReader.readOne(reader));
                        UpdateResponseImpl updateResponseImpl = actionResponse;
                        reader.close();
                        return updateResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            AffinityGroupServiceImpl.this.checkFault(response);
            return new UpdateResponseImpl();
        }
    }

    private class RemoveResponseImpl
    implements AffinityGroupService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<AffinityGroupService.RemoveRequest, AffinityGroupService.RemoveResponse>
    implements AffinityGroupService.RemoveRequest {
        private Boolean async;

        private RemoveRequestImpl() {
        }

        @Override
        public AffinityGroupService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public AffinityGroupService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(AffinityGroupServiceImpl.this.getConnection().getUrl() + AffinityGroupServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = AffinityGroupServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            AffinityGroupServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class GetResponseImpl
    implements AffinityGroupService.GetResponse {
        private AffinityGroup group;

        private GetResponseImpl() {
        }

        public void group(AffinityGroup group) {
            this.group = group;
        }

        @Override
        public AffinityGroup group() {
            return this.group;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<AffinityGroupService.GetRequest, AffinityGroupService.GetResponse>
    implements AffinityGroupService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public AffinityGroupService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public AffinityGroupService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(AffinityGroupServiceImpl.this.getConnection().getUrl() + AffinityGroupServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = AffinityGroupServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.group(XmlAffinityGroupReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            AffinityGroupServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

