/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.DiskBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.AttachedStorageDomainDiskServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskWriter;
import org.ovirt.engine.sdk4.services.AttachedStorageDomainDiskService;
import org.ovirt.engine.sdk4.services.AttachedStorageDomainDisksService;
import org.ovirt.engine.sdk4.types.Disk;

public class AttachedStorageDomainDisksServiceImpl
extends ServiceImpl
implements AttachedStorageDomainDisksService {
    public AttachedStorageDomainDisksServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public AttachedStorageDomainDisksService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public AttachedStorageDomainDisksService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public AttachedStorageDomainDiskService diskService(String id) {
        return new AttachedStorageDomainDiskServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.diskService(path);
        }
        return this.diskService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "AttachedStorageDomainDisksService:" + this.getPath();
    }

    private class ListResponseImpl
    implements AttachedStorageDomainDisksService.ListResponse {
        private List<Disk> disks;

        private ListResponseImpl() {
        }

        public void disks(List<Disk> disks) {
            this.disks = disks;
        }

        @Override
        public List<Disk> disks() {
            return this.disks;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<AttachedStorageDomainDisksService.ListRequest, AttachedStorageDomainDisksService.ListResponse>
    implements AttachedStorageDomainDisksService.ListRequest {
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public AttachedStorageDomainDisksService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public AttachedStorageDomainDisksService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public AttachedStorageDomainDisksService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public AttachedStorageDomainDisksService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public AttachedStorageDomainDisksService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(AttachedStorageDomainDisksServiceImpl.this.getConnection().getUrl() + AttachedStorageDomainDisksServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = AttachedStorageDomainDisksServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.disks(XmlDiskReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            AttachedStorageDomainDisksServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements AttachedStorageDomainDisksService.AddResponse {
        private Disk disk;

        private AddResponseImpl() {
        }

        public void disk(Disk disk) {
            this.disk = disk;
        }

        @Override
        public Disk disk() {
            return this.disk;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<AttachedStorageDomainDisksService.AddRequest, AttachedStorageDomainDisksService.AddResponse>
    implements AttachedStorageDomainDisksService.AddRequest {
        private Disk disk;
        private Boolean unregistered;

        private AddRequestImpl() {
        }

        @Override
        public AttachedStorageDomainDisksService.AddRequest disk(Disk disk) {
            this.disk = disk;
            return this;
        }

        @Override
        public AttachedStorageDomainDisksService.AddRequest disk(DiskBuilder disk) {
            this.disk = disk.build();
            return this;
        }

        @Override
        public AttachedStorageDomainDisksService.AddRequest unregistered(Boolean unregistered) {
            this.unregistered = unregistered;
            return this;
        }

        @Override
        public AttachedStorageDomainDisksService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(AttachedStorageDomainDisksServiceImpl.this.getConnection().getUrl() + AttachedStorageDomainDisksServiceImpl.this.getPath());
                if (this.unregistered != null) {
                    uriBuilder.addParameter("unregistered", XmlWriter.renderBoolean(this.unregistered));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlDiskWriter.writeOne(this.disk, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = AttachedStorageDomainDisksServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.disk(XmlDiskReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            AttachedStorageDomainDisksServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

