/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ClusterFeatureServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlClusterFeatureReader;
import org.ovirt.engine.sdk4.services.ClusterFeatureService;
import org.ovirt.engine.sdk4.services.ClusterFeaturesService;
import org.ovirt.engine.sdk4.types.ClusterFeature;

public class ClusterFeaturesServiceImpl
extends ServiceImpl
implements ClusterFeaturesService {
    public ClusterFeaturesServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public ClusterFeaturesService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public ClusterFeatureService featureService(String id) {
        return new ClusterFeatureServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.featureService(path);
        }
        return this.featureService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "ClusterFeaturesService:" + this.getPath();
    }

    private class ListResponseImpl
    implements ClusterFeaturesService.ListResponse {
        private List<ClusterFeature> features;

        private ListResponseImpl() {
        }

        public void features(List<ClusterFeature> features) {
            this.features = features;
        }

        @Override
        public List<ClusterFeature> features() {
            return this.features;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<ClusterFeaturesService.ListRequest, ClusterFeaturesService.ListResponse>
    implements ClusterFeaturesService.ListRequest {
        private String follow;

        private ListRequestImpl() {
        }

        @Override
        public ClusterFeaturesService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public ClusterFeaturesService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(ClusterFeaturesServiceImpl.this.getConnection().getUrl() + ClusterFeaturesServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = ClusterFeaturesServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.features(XmlClusterFeatureReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            ClusterFeaturesServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }
}

