/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.UserBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.AssignedPermissionsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.AssignedRolesServiceImpl;
import org.ovirt.engine.sdk4.internal.services.AssignedTagsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.DomainUserGroupsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.EventSubscriptionsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.services.SshPublicKeysServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlUserReader;
import org.ovirt.engine.sdk4.internal.xml.XmlUserWriter;
import org.ovirt.engine.sdk4.services.AssignedPermissionsService;
import org.ovirt.engine.sdk4.services.AssignedRolesService;
import org.ovirt.engine.sdk4.services.AssignedTagsService;
import org.ovirt.engine.sdk4.services.DomainUserGroupsService;
import org.ovirt.engine.sdk4.services.EventSubscriptionsService;
import org.ovirt.engine.sdk4.services.SshPublicKeysService;
import org.ovirt.engine.sdk4.services.UserService;
import org.ovirt.engine.sdk4.types.User;

public class UserServiceImpl
extends ServiceImpl
implements UserService {
    public UserServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public UserService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public UserService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public UserService.UpdateRequest update() {
        return new UpdateRequestImpl();
    }

    @Override
    public EventSubscriptionsService eventSubscriptionsService() {
        return new EventSubscriptionsServiceImpl(this.getConnection(), this.getPath() + "/eventsubscriptions");
    }

    @Override
    public DomainUserGroupsService groupsService() {
        return new DomainUserGroupsServiceImpl(this.getConnection(), this.getPath() + "/groups");
    }

    @Override
    public AssignedPermissionsService permissionsService() {
        return new AssignedPermissionsServiceImpl(this.getConnection(), this.getPath() + "/permissions");
    }

    @Override
    public AssignedRolesService rolesService() {
        return new AssignedRolesServiceImpl(this.getConnection(), this.getPath() + "/roles");
    }

    @Override
    public SshPublicKeysService sshPublicKeysService() {
        return new SshPublicKeysServiceImpl(this.getConnection(), this.getPath() + "/sshpublickeys");
    }

    @Override
    public AssignedTagsService tagsService() {
        return new AssignedTagsServiceImpl(this.getConnection(), this.getPath() + "/tags");
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        if (path.equals("eventsubscriptions")) {
            return this.eventSubscriptionsService();
        }
        if (path.startsWith("eventsubscriptions/")) {
            return this.eventSubscriptionsService().service(path.substring(19));
        }
        if (path.equals("groups")) {
            return this.groupsService();
        }
        if (path.startsWith("groups/")) {
            return this.groupsService().service(path.substring(7));
        }
        if (path.equals("permissions")) {
            return this.permissionsService();
        }
        if (path.startsWith("permissions/")) {
            return this.permissionsService().service(path.substring(12));
        }
        if (path.equals("roles")) {
            return this.rolesService();
        }
        if (path.startsWith("roles/")) {
            return this.rolesService().service(path.substring(6));
        }
        if (path.equals("sshpublickeys")) {
            return this.sshPublicKeysService();
        }
        if (path.startsWith("sshpublickeys/")) {
            return this.sshPublicKeysService().service(path.substring(14));
        }
        if (path.equals("tags")) {
            return this.tagsService();
        }
        if (path.startsWith("tags/")) {
            return this.tagsService().service(path.substring(5));
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "UserService:" + this.getPath();
    }

    private class UpdateResponseImpl
    implements UserService.UpdateResponse {
        private User user;

        private UpdateResponseImpl() {
        }

        public void user(User user) {
            this.user = user;
        }

        @Override
        public User user() {
            return this.user;
        }
    }

    private class UpdateRequestImpl
    extends BaseRequest<UserService.UpdateRequest, UserService.UpdateResponse>
    implements UserService.UpdateRequest {
        private User user;

        private UpdateRequestImpl() {
        }

        @Override
        public UserService.UpdateRequest user(User user) {
            this.user = user;
            return this;
        }

        @Override
        public UserService.UpdateRequest user(UserBuilder user) {
            this.user = user.build();
            return this;
        }

        @Override
        public UserService.UpdateResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(UserServiceImpl.this.getConnection().getUrl() + UserServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlUserWriter.writeOne(this.user, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = UserServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateResponseImpl actionResponse = new UpdateResponseImpl();
                        actionResponse.user(XmlUserReader.readOne(reader));
                        UpdateResponseImpl updateResponseImpl = actionResponse;
                        reader.close();
                        return updateResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            UserServiceImpl.this.checkFault(response);
            return new UpdateResponseImpl();
        }
    }

    private class RemoveResponseImpl
    implements UserService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<UserService.RemoveRequest, UserService.RemoveResponse>
    implements UserService.RemoveRequest {
        private Boolean async;

        private RemoveRequestImpl() {
        }

        @Override
        public UserService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public UserService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(UserServiceImpl.this.getConnection().getUrl() + UserServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = UserServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            UserServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class GetResponseImpl
    implements UserService.GetResponse {
        private User user;

        private GetResponseImpl() {
        }

        public void user(User user) {
            this.user = user;
        }

        @Override
        public User user() {
            return this.user;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<UserService.GetRequest, UserService.GetResponse>
    implements UserService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public UserService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public UserService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(UserServiceImpl.this.getConnection().getUrl() + UserServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = UserServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.user(XmlUserReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            UserServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

